<?php
/**
 * Buttons X Form Elements
 *
 * This file is used to output form elements.
 *
 * @package Buttons X
 * @since 0.1
 */

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'BtnsxFormElements' ) ) {
	
	class BtnsxFormElements {

		private static $instance;

		/**
		 * Initiator
		 * @since 0.1
		 */

		public static function init(){
			return self::$instance;
		}

		public function get_post_types( $unset ) {
			$post_types = get_post_types( array( 'public' => true ), 'names' );
			$output = array();
			foreach ( $post_types as $type ) {
				$output[$type] = ucfirst($type);
			}
			foreach ( $unset as $u ) {
				if( isset($output[$u]) ) {
					unset($output[$u]);
				}
			}
			return $output;
		}

		/**
		 * CPT as select options html
		 * @since  1.8.0
		 * @param  string/array    $type
		 * @param  string/array    $selected
		 * @return string
		 */
		public function cpt_html( $type, $selected ) {
			$options = array();

			$args = array(
				'post_type' => $type,
				'post_status' => 'publish',
				'posts_per_page' => -1
			);
			$query = new WP_Query( $args );
			// The Loop
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$options[ get_the_ID() ] = get_the_title();
				}
			} else {
				// no posts found
			}
			/* Restore original Post Data */
			wp_reset_postdata();

			$output = '';
			foreach ( $options as $k => $l ) {
				if( is_array( $selected ) ) {
					if( in_array( $k, $selected ) ) {
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					} else {
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				} else {
					if( $k == $selected ){
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					} else {
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				}
			}

			return $output;
		}

		/**
		 * CPT as select options
		 * @since  0.1
		 * @param  string/array    $type
		 * @param  string/array    $selected
		 * @return string
		 */
		public function cpt( $type, $selected ) {
			$options = array();

			$args = array(
				'post_type' => $type,
				'post_status' => 'publish',
				'posts_per_page' => -1
			);
			$query = new WP_Query( $args );
			// The Loop
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$options[ get_the_ID() ] = get_the_title();
				}
			} else {
				// no posts found
				$options[ '' ] = __( 'No posts found', 'btnsx' );
			}
			/* Restore original Post Data */
			wp_reset_postdata();

			// $output = '';
			// foreach ( $options as $k => $l ) {
			// 	if( is_array( $selected ) ) {
			// 		if( in_array( $k, $selected ) ) {
			// 			$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
			// 		} else {
			// 			$output .= '<option value="' . $k . '">' . $l . '</option>';
			// 		}
			// 	} else {
			// 		if( $k == $selected ){
			// 			$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
			// 		} else {
			// 			$output .= '<option value="' . $k . '">' . $l . '</option>';
			// 		}
			// 	}
			// }
			$output = array();
			foreach ( $options as $k => $l ) {
				$output[$k] = ucfirst($l);
			}

			return $output;
		}

		/**
		 * Post/Page/CPT's as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function posts( $selected ) {
			$post_types = get_post_types( array( 'public' => true ) );
			$options = array();
			foreach ( $post_types as $key => $type ) {
				if( !in_array( $type, array( 'buttons-x', 'buttons-x-social', 'buttons-x-dual', 'buttons-x-cs' ) ) ) {
					$args = array( 'post_type' => $type, 'posts_per_page' => -1, 'post_status' => 'publish', 'post_parent' => null ); 
					$posts = get_posts( $args );
					if ( $posts ) {
						foreach ( $posts as $post ) {
							$options[ ucfirst( $type ) ][ $post->ID ] = $post->post_title;
						}
						wp_reset_postdata();
					}
				}
			}

			$output = '';
	
			foreach ( $options as $option => $label ) {
				$output .= '<optgroup label="' . $option . '">';
				foreach ( $label as $k => $l ) {
					if( is_array( $selected ) ) {
						if( in_array( $k, $selected ) ) {
							$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
						} else {
							$output .= '<option value="' . $k . '">' . $l . '</option>';
						}
					} else {
						if( $k == $selected ){
							$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
						} else {
							$output .= '<option value="' . $k . '">' . $l . '</option>';
						}
					}
				}
				$output .= '</optgroup>';
			}

			return $output;
		}

		/**
		 * Post/Page/CPT links as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function post_links( $selected ) {
			$post_types = get_post_types( array( 'public' => true ) );
			$options = array();
			foreach ( $post_types as $key => $type ) {
				if( !in_array( $type, array( 'buttons-x', 'buttons-x-social', 'buttons-x-dual', 'buttons-x-cs' ) ) ) {
					$args = array(
						'post_type' => $type,
						'post_status' => 'publish',
						'posts_per_page' => -1
					);
					$query = new WP_Query( $args );
					// The Loop
					if ( $query->have_posts() ) {
						while ( $query->have_posts() ) {
							$query->the_post();
							$options[ ucfirst( $type ) ][ get_permalink() ] = get_the_title();
						}
					} else {
						// no posts found
					}
					/* Restore original Post Data */
					wp_reset_postdata();
				}
			}

			$output = '';
	
			foreach ( $options as $option => $label ) {
				$output .= '<optgroup label="' . $option . '">';
				foreach ( $label as $k => $l ) {
					if( $k == $selected ){
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					}else{
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				}
				$output .= '</optgroup>';
			}

			return $output;
		}

		/**
		 * Font Awesome Icons as select options
		 * @since  0.1
		 * @return string
		 */
		public function icon_options( $selected ){
			$icons = array( 
				__( 'FONT AWESOME ICONS', 'btnsx' ) => array(
					__( 'Accessibility', 'btnsx' ) => array( ' ', 'fab fa-accessible-icon', 'fas fa-american-sign-language-interpreting', 'fas fa-assistive-listening-systems', 'fas fa-audio-description', 'fas fa-blind', 'fas fa-braille', 'fas fa-closed-captioning', 'far fa-closed-captioning', 'fas fa-deaf', 'fas fa-low-vision', 'fas fa-phone-volume', 'fas fa-question-circle', 'far fa-question-circle', 'fas fa-sign-language', 'fas fa-tty', 'fas fa-universal-access', 'fas fa-wheelchair'),
					__( 'Alert', 'btnsx' ) => array( 'fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fas fa-exclamation','fas fa-exclamation-circle','fas fa-exclamation-triangle','fas fa-radiation','fas fa-radiation-alt','fas fa-skull-crossbones' ),
					__( 'Animals', 'btnsx' ) => array( 'fas fa-cat','fas fa-crow','fas fa-dog','fas fa-dove','fas fa-dragon','fas fa-feather','fas fa-feather-alt','fas fa-fish','fas fa-frog','fas fa-hippo','fas fa-horse','fas fa-horse-head','fas fa-kiwi-bird','fas fa-otter','fas fa-paw','fas fa-spider', ),
					__( 'Arrows', 'btnsx' ) => array( 'fas fa-angle-double-down','fas fa-angle-double-left','fas fa-angle-double-right','fas fa-angle-double-up','fas fa-angle-down','fas fa-angle-left','fas fa-angle-right','fas fa-angle-up','fas fa-arrow-alt-circle-down','far fa-arrow-alt-circle-down','fas fa-arrow-alt-circle-left','far fa-arrow-alt-circle-left','fas fa-arrow-alt-circle-right','far fa-arrow-alt-circle-right','fas fa-arrow-alt-circle-up','far fa-arrow-alt-circle-up','fas fa-arrow-circle-down','fas fa-arrow-circle-left','fas fa-arrow-circle-right','fas fa-arrow-circle-up','fas fa-arrow-down','fas fa-arrow-left','fas fa-arrow-right','fas fa-arrow-up','fas fa-arrows-alt','fas fa-arrows-alt-h','fas fa-arrows-alt-v','fas fa-caret-down','fas fa-caret-left','fas fa-caret-right','fas fa-caret-square-down','far fa-caret-square-down','fas fa-caret-square-left','far fa-caret-square-left','fas fa-caret-square-right','far fa-caret-square-right','fas fa-caret-square-up','far fa-caret-square-up','fas fa-caret-up','fas fa-cart-arrow-down','fas fa-chart-line','fas fa-chevron-circle-down','fas fa-chevron-circle-left','fas fa-chevron-circle-right','fas fa-chevron-circle-up','fas fa-chevron-down','fas fa-chevron-left','fas fa-chevron-right','fas fa-chevron-up','fas fa-cloud-download-alt','fas fa-cloud-upload-alt','fas fa-compress-arrows-alt','fas fa-download','fas fa-exchange-alt','fas fa-expand-arrows-alt','fas fa-external-link-alt','fas fa-external-link-square-alt','fas fa-hand-point-down','far fa-hand-point-down','fas fa-hand-point-left','far fa-hand-point-left','fas fa-hand-point-right','far fa-hand-point-right','fas fa-hand-point-up','far fa-hand-point-up','fas fa-hand-pointer','far fa-hand-pointer','fas fa-history','fas fa-level-down-alt','fas fa-level-up-alt','fas fa-location-arrow','fas fa-long-arrow-alt-down','fas fa-long-arrow-alt-left','fas fa-long-arrow-alt-right','fas fa-long-arrow-alt-up','fas fa-mouse-pointer','fas fa-play','fas fa-random','fas fa-recycle','fas fa-redo','fas fa-redo-alt','fas fa-reply','fas fa-reply-all','fas fa-retweet','fas fa-share','fas fa-share-square','far fa-share-square','fas fa-sign-in-alt','fas fa-sign-out-alt','fas fa-sort','fas fa-sort-alpha-down','fas fa-sort-alpha-down-alt','fas fa-sort-alpha-up','fas fa-sort-alpha-up-alt','fas fa-sort-amount-down','fas fa-sort-amount-down-alt','fas fa-sort-amount-up','fas fa-sort-amount-up-alt','fas fa-sort-down','fas fa-sort-numeric-down','fas fa-sort-numeric-down-alt','fas fa-sort-numeric-up','fas fa-sort-numeric-up-alt','fas fa-sort-up','fas fa-sync','fas fa-sync-alt','fas fa-text-height','fas fa-text-width','fas fa-undo','fas fa-undo-alt','fas fa-upload', ),
					__( 'Audio & Video', 'btnsx' ) => array( 'fas fa-audio-description','fas fa-backward','fas fa-broadcast-tower','fas fa-circle','far fa-circle','fas fa-closed-captioning','far fa-closed-captioning','fas fa-compress','fas fa-compress-arrows-alt','fas fa-eject','fas fa-expand','fas fa-expand-arrows-alt','fas fa-fast-backward','fas fa-fast-forward','fas fa-file-audio','far fa-file-audio','fas fa-file-video','far fa-file-video','fas fa-film','fas fa-forward','fas fa-headphones','fas fa-microphone','fas fa-microphone-alt','fas fa-microphone-alt-slash','fas fa-microphone-slash','fas fa-music','fas fa-pause','fas fa-pause-circle','far fa-pause-circle','fas fa-phone-volume','fas fa-photo-video','fas fa-play','fas fa-play-circle','far fa-play-circle','fas fa-podcast','fas fa-random','fas fa-redo','fas fa-redo-alt','fas fa-rss','fas fa-rss-square','fas fa-step-backward','fas fa-step-forward','fas fa-stop','fas fa-stop-circle','far fa-stop-circle','fas fa-sync','fas fa-sync-alt','fas fa-undo','fas fa-undo-alt','fas fa-video','fas fa-volume-down','fas fa-volume-mute','fas fa-volume-off','fas fa-volume-up','fab fa-youtube', ),
					__( 'Automotive', 'btnsx' ) => array( 'fas fa-air-freshener','fas fa-ambulance','fas fa-bus','fas fa-bus-alt','fas fa-car','fas fa-car-alt','fas fa-car-battery','fas fa-car-crash','fas fa-car-side','fas fa-charging-station','fas fa-gas-pump','fas fa-motorcycle','fas fa-oil-can','fas fa-shuttle-van','fas fa-tachometer-alt','fas fa-taxi','fas fa-truck','fas fa-truck-monster','fas fa-truck-pickup', ),
					__( 'Autumn', 'btnsx' ) => array( 'fas fa-apple-alt','fas fa-campground','fas fa-cloud-sun','fas fa-drumstick-bite','fas fa-football-ball','fas fa-hiking','fas fa-mountain','fas fa-tractor','fas fa-tree','fas fa-wind','fas fa-wine-bottle', ),
					__( 'Beverage', 'btnsx' ) => array( 'fas fa-beer','fas fa-blender','fas fa-cocktail','fas fa-coffee','fas fa-flask','fas fa-glass-cheers','fas fa-glass-martini','fas fa-glass-martini-alt','fas fa-glass-whiskey','fas fa-mug-hot','fas fa-wine-bottle','fas fa-wine-glass','fas fa-wine-glass-alt', ),
					__( 'Brands', 'btnsx' ) => array( 'fab fa-500px','fab fa-accessible-icon','fab fa-accusoft','fab fa-acquisitions-incorporated','fab fa-adn','fab fa-adobe','fab fa-adversal','fab fa-affiliatetheme','fab fa-airbnb','fab fa-algolia','fab fa-alipay','fab fa-amazon','fab fa-amazon-pay','fab fa-amilia','fab fa-android','fab fa-angellist','fab fa-angrycreative','fab fa-angular','fab fa-app-store','fab fa-app-store-ios','fab fa-apper','fab fa-apple','fab fa-apple-pay','fab fa-artstation','fab fa-asymmetrik','fab fa-atlassian','fab fa-audible','fab fa-autoprefixer','fab fa-avianex','fab fa-aviato','fab fa-aws','fab fa-bandcamp','fab fa-battle-net','fab fa-behance','fab fa-behance-square','fab fa-bimobject','fab fa-bitbucket','fab fa-bitcoin','fab fa-bity','fab fa-black-tie','fab fa-blackberry','fab fa-blogger','fab fa-blogger-b','fab fa-bluetooth','fab fa-bluetooth-b','fab fa-bootstrap','fab fa-btc','fab fa-buffer','fab fa-buromobelexperte','fab fa-buysellads','fab fa-canadian-maple-leaf','fab fa-cc-amazon-pay','fab fa-cc-amex','fab fa-cc-apple-pay','fab fa-cc-diners-club','fab fa-cc-discover','fab fa-cc-jcb','fab fa-cc-mastercard','fab fa-cc-paypal','fab fa-cc-stripe','fab fa-cc-visa','fab fa-centercode','fab fa-centos','fab fa-chrome','fab fa-chromecast','fab fa-cloudscale','fab fa-cloudsmith','fab fa-cloudversify','fab fa-codepen','fab fa-codiepie','fab fa-confluence','fab fa-connectdevelop','fab fa-contao','fab fa-cpanel','fab fa-creative-commons','fab fa-creative-commons-by','fab fa-creative-commons-nc','fab fa-creative-commons-nc-eu','fab fa-creative-commons-nc-jp','fab fa-creative-commons-nd','fab fa-creative-commons-pd','fab fa-creative-commons-pd-alt','fab fa-creative-commons-remix','fab fa-creative-commons-sa','fab fa-creative-commons-sampling','fab fa-creative-commons-sampling-plus','fab fa-creative-commons-share','fab fa-creative-commons-zero','fab fa-critical-role','fab fa-css3','fab fa-css3-alt','fab fa-cuttlefish','fab fa-d-and-d','fab fa-d-and-d-beyond','fab fa-dashcube','fab fa-delicious','fab fa-deploydog','fab fa-deskpro','fab fa-dev','fab fa-deviantart','fab fa-dhl','fab fa-diaspora','fab fa-digg','fab fa-digital-ocean','fab fa-discord','fab fa-discourse','fab fa-dochub','fab fa-docker','fab fa-draft2digital','fab fa-dribbble','fab fa-dribbble-square','fab fa-dropbox','fab fa-drupal','fab fa-dyalog','fab fa-earlybirds','fab fa-ebay','fab fa-edge','fab fa-elementor','fab fa-ello','fab fa-ember','fab fa-empire','fab fa-envira','fab fa-erlang','fab fa-ethereum','fab fa-etsy','fab fa-evernote','fab fa-expeditedssl','fab fa-facebook','fab fa-facebook-f','fab fa-facebook-messenger','fab fa-facebook-square','fab fa-fantasy-flight-games','fab fa-fedex','fab fa-fedora','fab fa-figma','fab fa-firefox','fab fa-first-order','fab fa-first-order-alt','fab fa-firstdraft','fab fa-flickr','fab fa-flipboard','fab fa-fly','fab fa-font-awesome','fab fa-font-awesome-alt','fab fa-font-awesome-flag','fab fa-fonticons','fab fa-fonticons-fi','fab fa-fort-awesome','fab fa-fort-awesome-alt','fab fa-forumbee','fab fa-foursquare','fab fa-free-code-camp','fab fa-freebsd','fab fa-fulcrum','fab fa-galactic-republic','fab fa-galactic-senate','fab fa-get-pocket','fab fa-gg','fab fa-gg-circle','fab fa-git','fab fa-git-alt','fab fa-git-square','fab fa-github','fab fa-github-alt','fab fa-github-square','fab fa-gitkraken','fab fa-gitlab','fab fa-gitter','fab fa-glide','fab fa-glide-g','fab fa-gofore','fab fa-goodreads','fab fa-goodreads-g','fab fa-google','fab fa-google-drive','fab fa-google-play','fab fa-google-plus','fab fa-google-plus-g','fab fa-google-plus-square','fab fa-google-wallet','fab fa-gratipay','fab fa-grav','fab fa-gripfire','fab fa-grunt','fab fa-gulp','fab fa-hacker-news','fab fa-hacker-news-square','fab fa-hackerrank','fab fa-hips','fab fa-hire-a-helper','fab fa-hooli','fab fa-hornbill','fab fa-hotjar','fab fa-houzz','fab fa-html5','fab fa-hubspot','fab fa-imdb','fab fa-instagram','fab fa-intercom','fab fa-internet-explorer','fab fa-invision','fab fa-ioxhost','fab fa-itch-io','fab fa-itunes','fab fa-itunes-note','fab fa-java','fab fa-jedi-order','fab fa-jenkins','fab fa-jira','fab fa-joget','fab fa-joomla','fab fa-js','fab fa-js-square','fab fa-jsfiddle','fab fa-kaggle','fab fa-keybase','fab fa-keycdn','fab fa-kickstarter','fab fa-kickstarter-k','fab fa-korvue','fab fa-laravel','fab fa-lastfm','fab fa-lastfm-square','fab fa-leanpub','fab fa-less','fab fa-line','fab fa-linkedin','fab fa-linkedin-in','fab fa-linode','fab fa-linux','fab fa-lyft','fab fa-magento','fab fa-mailchimp','fab fa-mandalorian','fab fa-markdown','fab fa-mastodon','fab fa-maxcdn','fab fa-medapps','fab fa-medium','fab fa-medium-m','fab fa-medrt','fab fa-meetup','fab fa-megaport','fab fa-mendeley','fab fa-microsoft','fab fa-mix','fab fa-mixcloud','fab fa-mizuni','fab fa-modx','fab fa-monero','fab fa-napster','fab fa-neos','fab fa-nimblr','fab fa-node','fab fa-node-js','fab fa-npm','fab fa-ns8','fab fa-nutritionix','fab fa-odnoklassniki','fab fa-odnoklassniki-square','fab fa-old-republic','fab fa-opencart','fab fa-openid','fab fa-opera','fab fa-optin-monster','fab fa-osi','fab fa-page4','fab fa-pagelines','fab fa-palfed','fab fa-patreon','fab fa-paypal','fab fa-penny-arcade','fab fa-periscope','fab fa-phabricator','fab fa-phoenix-framework','fab fa-phoenix-squadron','fab fa-php','fab fa-pied-piper','fab fa-pied-piper-alt','fab fa-pied-piper-hat','fab fa-pied-piper-pp','fab fa-pinterest','fab fa-pinterest-p','fab fa-pinterest-square','fab fa-playstation','fab fa-product-hunt','fab fa-pushed','fab fa-python','fab fa-qq','fab fa-quinscape','fab fa-quora','fab fa-r-project','fab fa-raspberry-pi','fab fa-ravelry','fab fa-react','fab fa-reacteurope','fab fa-readme','fab fa-rebel','fab fa-red-river','fab fa-reddit','fab fa-reddit-alien','fab fa-reddit-square','fab fa-redhat','fab fa-renren','fab fa-replyd','fab fa-researchgate','fab fa-resolving','fab fa-rev','fab fa-rocketchat','fab fa-rockrms','fab fa-safari','fab fa-salesforce','fab fa-sass','fab fa-schlix','fab fa-scribd','fab fa-searchengin','fab fa-sellcast','fab fa-sellsy','fab fa-servicestack','fab fa-shirtsinbulk','fab fa-shopware','fab fa-simplybuilt','fab fa-sistrix','fab fa-sith','fab fa-sketch','fab fa-skyatlas','fab fa-skype','fab fa-slack','fab fa-slack-hash','fab fa-slideshare','fab fa-snapchat','fab fa-snapchat-ghost','fab fa-snapchat-square','fab fa-soundcloud','fab fa-sourcetree','fab fa-speakap','fab fa-speaker-deck','fab fa-spotify','fab fa-squarespace','fab fa-stack-exchange','fab fa-stack-overflow','fab fa-stackpath','fab fa-staylinked','fab fa-steam','fab fa-steam-square','fab fa-steam-symbol','fab fa-sticker-mule','fab fa-strava','fab fa-stripe','fab fa-stripe-s','fab fa-studiovinari','fab fa-stumbleupon','fab fa-stumbleupon-circle','fab fa-superpowers','fab fa-supple','fab fa-suse','fab fa-symfony','fab fa-teamspeak','fab fa-telegram','fab fa-telegram-plane','fab fa-tencent-weibo','fab fa-the-red-yeti','fab fa-themeco','fab fa-themeisle','fab fa-think-peaks','fab fa-trade-federation','fab fa-trello','fab fa-tripadvisor','fab fa-tumblr','fab fa-tumblr-square','fab fa-twitch','fab fa-twitter','fab fa-twitter-square','fab fa-typo3','fab fa-uber','fab fa-ubuntu','fab fa-uikit','fab fa-uniregistry','fab fa-untappd','fab fa-ups','fab fa-usb','fab fa-usps','fab fa-ussunnah','fab fa-vaadin','fab fa-viacoin','fab fa-viadeo','fab fa-viadeo-square','fab fa-viber','fab fa-vimeo','fab fa-vimeo-square','fab fa-vimeo-v','fab fa-vine','fab fa-vk','fab fa-vnv','fab fa-vuejs','fab fa-waze','fab fa-weebly','fab fa-weibo','fab fa-weixin','fab fa-whatsapp','fab fa-whatsapp-square','fab fa-whmcs','fab fa-wikipedia-w','fab fa-windows','fab fa-wix','fab fa-wizards-of-the-coast','fab fa-wolf-pack-battalion','fab fa-wordpress','fab fa-wordpress-simple','fab fa-wpbeginner','fab fa-wpexplorer','fab fa-wpforms','fab fa-wpressr','fab fa-xbox','fab fa-xing','fab fa-xing-square','fab fa-y-combinator','fab fa-yahoo','fab fa-yammer','fab fa-yandex','fab fa-yandex-international','fab fa-yarn','fab fa-yelp','fab fa-yoast','fab fa-youtube','fab fa-youtube-square','fab fa-zhihu' ),
					__( 'Buildings', 'btnsx' ) => array( 'fas fa-archway','fas fa-building','far fa-building','fas fa-campground','fas fa-church','fas fa-city','fas fa-clinic-medical','fas fa-dungeon','fas fa-gopuram','fas fa-home','fas fa-hospital','far fa-hospital','fas fa-hospital-alt','fas fa-hotel','fas fa-house-damage','fas fa-igloo','fas fa-industry','fas fa-kaaba','fas fa-landmark','fas fa-monument','fas fa-mosque','fas fa-place-of-worship','fas fa-school','fas fa-store','fas fa-store-alt','fas fa-synagogue','fas fa-torii-gate','fas fa-university','fas fa-vihara','fas fa-warehouse', ),
					__( 'Business', 'btnsx' ) => array( 'fas fa-address-book','far fa-address-book','fas fa-address-card','far fa-address-card','fas fa-archive','fas fa-balance-scale','fas fa-balance-scale-left','fas fa-balance-scale-right','fas fa-birthday-cake','fas fa-book','fas fa-briefcase','fas fa-building','far fa-building','fas fa-bullhorn','fas fa-bullseye','fas fa-business-time','fas fa-calculator','fas fa-calendar','far fa-calendar','fas fa-calendar-alt','far fa-calendar-alt','fas fa-certificate','fas fa-chart-area','fas fa-chart-bar','far fa-chart-bar','fas fa-chart-line','fas fa-chart-pie','fas fa-city','fas fa-clipboard','far fa-clipboard','fas fa-coffee','fas fa-columns','fas fa-compass','far fa-compass','fas fa-copy','far fa-copy','fas fa-copyright','far fa-copyright','fas fa-cut','fas fa-edit','far fa-edit','fas fa-envelope','far fa-envelope','fas fa-envelope-open','far fa-envelope-open','fas fa-envelope-square','fas fa-eraser','fas fa-fax','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-folder','far fa-folder','fas fa-folder-minus','fas fa-folder-open','far fa-folder-open','fas fa-folder-plus','fas fa-glasses','fas fa-globe','fas fa-highlighter','fas fa-industry','fas fa-landmark','fas fa-marker','fas fa-paperclip','fas fa-paste','fas fa-pen','fas fa-pen-alt','fas fa-pen-fancy','fas fa-pen-nib','fas fa-pen-square','fas fa-pencil-alt','fas fa-percent','fas fa-phone','fas fa-phone-alt','fas fa-phone-slash','fas fa-phone-square','fas fa-phone-square-alt','fas fa-phone-volume','fas fa-print','fas fa-project-diagram','fas fa-registered','far fa-registered','fas fa-save','far fa-save','fas fa-sitemap','fas fa-socks','fas fa-sticky-note','far fa-sticky-note','fas fa-stream','fas fa-table','fas fa-tag','fas fa-tags','fas fa-tasks','fas fa-thumbtack','fas fa-trademark','fas fa-wallet', ),
					__( 'Camping', 'btnsx' ) => array( 'fas fa-binoculars','fas fa-campground','fas fa-compass','far fa-compass','fas fa-fire','fas fa-fire-alt','fas fa-first-aid','fas fa-frog','fas fa-hiking','fas fa-map','far fa-map','fas fa-map-marked','fas fa-map-marked-alt','fas fa-map-signs','fas fa-mountain','fas fa-route','fas fa-toilet-paper','fas fa-tree', ),
					__( 'Charity', 'btnsx' ) => array( 'fas fa-dollar-sign','fas fa-donate','fas fa-dove','fas fa-gift','fas fa-globe','fas fa-hand-holding-heart','fas fa-hand-holding-usd','fas fa-hands-helping','fas fa-handshake','far fa-handshake','fas fa-heart','far fa-heart','fas fa-leaf','fas fa-parachute-box','fas fa-piggy-bank','fas fa-ribbon','fas fa-seedling', ),
					__( 'Chat', 'btnsx' ) => array( 'fas fa-comment','far fa-comment','fas fa-comment-alt','far fa-comment-alt','fas fa-comment-dots','far fa-comment-dots','fas fa-comment-medical','fas fa-comment-slash','fas fa-comments','far fa-comments','fas fa-frown','far fa-frown','fas fa-icons','fas fa-meh','far fa-meh','fas fa-phone','fas fa-phone-alt','fas fa-phone-slash','fas fa-poo','fas fa-quote-left','fas fa-quote-right','fas fa-smile','far fa-smile','fas fa-sms','fas fa-video','fas fa-video-slash', ),
					__( 'Chess', 'btnsx' ) => array( 'fas fa-chess','fas fa-chess-bishop','fas fa-chess-board','fas fa-chess-king','fas fa-chess-knight','fas fa-chess-pawn','fas fa-chess-queen','fas fa-chess-rook','fas fa-square-full', ),
					__( 'Childhood', 'btnsx' ) => array( 'fas fa-apple-alt','fas fa-baby','fas fa-baby-carriage','fas fa-bath','fas fa-biking','fas fa-birthday-cake','fas fa-cookie','fas fa-cookie-bite','fas fa-ice-cream','fas fa-mitten','fas fa-robot','fas fa-school','fas fa-shapes','fas fa-snowman', ),
					__( 'Clothing', 'btnsx' ) => array( 'fas fa-graduation-cap','fas fa-hat-wizard','fas fa-mitten','fas fa-shoe-prints','fas fa-socks','fas fa-tshirt','fas fa-user-tie', ),
					__( 'Code', 'btnsx' ) => array( 'fas fa-archive','fas fa-barcode','fas fa-bath','fas fa-bug','fas fa-code','fas fa-code-branch','fas fa-coffee','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-file-code','far fa-file-code','fas fa-filter','fas fa-fire-extinguisher','fas fa-folder','far fa-folder','fas fa-folder-open','far fa-folder-open','fas fa-keyboard','far fa-keyboard','fas fa-laptop-code','fas fa-microchip','fas fa-project-diagram','fas fa-qrcode','fas fa-shield-alt','fas fa-sitemap','fas fa-stream','fas fa-terminal','fas fa-user-secret','fas fa-window-close','far fa-window-close','fas fa-window-maximize','far fa-window-maximize','fas fa-window-minimize','far fa-window-minimize','fas fa-window-restore','far fa-window-restore', ),
					__( 'Communication', 'btnsx' ) => array( 'fas fa-address-book','far fa-address-book','fas fa-address-card','far fa-address-card','fas fa-american-sign-language-interpreting','fas fa-assistive-listening-systems','fas fa-at','fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fab fa-bluetooth','fab fa-bluetooth-b','fas fa-broadcast-tower','fas fa-bullhorn','fas fa-chalkboard','fas fa-comment','far fa-comment','fas fa-comment-alt','far fa-comment-alt','fas fa-comments','far fa-comments','fas fa-envelope','far fa-envelope','fas fa-envelope-open','far fa-envelope-open','fas fa-envelope-square','fas fa-fax','fas fa-inbox','fas fa-language','fas fa-microphone','fas fa-microphone-alt','fas fa-microphone-alt-slash','fas fa-microphone-slash','fas fa-mobile','fas fa-mobile-alt','fas fa-paper-plane','far fa-paper-plane','fas fa-phone','fas fa-phone-alt','fas fa-phone-slash','fas fa-phone-square','fas fa-phone-square-alt','fas fa-phone-volume','fas fa-rss','fas fa-rss-square','fas fa-tty','fas fa-voicemail','fas fa-wifi', ),
					__( 'Computers', 'btnsx' ) => array( 'fas fa-database','fas fa-desktop','fas fa-download','fas fa-ethernet','fas fa-hdd','far fa-hdd','fas fa-headphones','fas fa-keyboard','far fa-keyboard','fas fa-laptop','fas fa-memory','fas fa-microchip','fas fa-mobile','fas fa-mobile-alt','fas fa-plug','fas fa-power-off','fas fa-print','fas fa-satellite','fas fa-satellite-dish','fas fa-save','far fa-save','fas fa-sd-card','fas fa-server','fas fa-sim-card','fas fa-stream','fas fa-tablet','fas fa-tablet-alt','fas fa-tv','fas fa-upload', ),
					__( 'Construction', 'btnsx' ) => array( 'fas fa-brush','fas fa-drafting-compass','fas fa-dumpster','fas fa-hammer','fas fa-hard-hat','fas fa-paint-roller','fas fa-pencil-alt','fas fa-pencil-ruler','fas fa-ruler','fas fa-ruler-combined','fas fa-ruler-horizontal','fas fa-ruler-vertical','fas fa-screwdriver','fas fa-toolbox','fas fa-tools','fas fa-truck-pickup','fas fa-wrench', ),
					__( 'Currency', 'btnsx' ) => array( 'fab fa-bitcoin','fab fa-btc','fas fa-dollar-sign','fab fa-ethereum','fas fa-euro-sign','fab fa-gg','fab fa-gg-circle','fas fa-hryvnia','fas fa-lira-sign','fas fa-money-bill','fas fa-money-bill-alt','far fa-money-bill-alt','fas fa-money-bill-wave','fas fa-money-bill-wave-alt','fas fa-money-check','fas fa-money-check-alt','fas fa-pound-sign','fas fa-ruble-sign','fas fa-rupee-sign','fas fa-shekel-sign','fas fa-tenge','fas fa-won-sign','fas fa-yen-sign', ),
					__( 'Date & Time', 'btnsx' ) => array( 'fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fas fa-calendar','far fa-calendar','fas fa-calendar-alt','far fa-calendar-alt','fas fa-calendar-check','far fa-calendar-check','fas fa-calendar-minus','far fa-calendar-minus','fas fa-calendar-plus','far fa-calendar-plus','fas fa-calendar-times','far fa-calendar-times','fas fa-clock','far fa-clock','fas fa-hourglass','far fa-hourglass','fas fa-hourglass-end','fas fa-hourglass-half','fas fa-hourglass-start','fas fa-stopwatch', ),
					__( 'Design', 'btnsx' ) => array( 'fas fa-adjust','fas fa-bezier-curve','fas fa-brush','fas fa-clone','far fa-clone','fas fa-copy','far fa-copy','fas fa-crop','fas fa-crop-alt','fas fa-crosshairs','fas fa-cut','fas fa-drafting-compass','fas fa-draw-polygon','fas fa-edit','far fa-edit','fas fa-eraser','fas fa-eye','far fa-eye','fas fa-eye-dropper','fas fa-eye-slash','far fa-eye-slash','fas fa-fill','fas fa-fill-drip','fas fa-highlighter','fas fa-icons','fas fa-layer-group','fas fa-magic','fas fa-marker','fas fa-object-group','far fa-object-group','fas fa-object-ungroup','far fa-object-ungroup','fas fa-paint-brush','fas fa-paint-roller','fas fa-palette','fas fa-paste','fas fa-pen','fas fa-pen-alt','fas fa-pen-fancy','fas fa-pen-nib','fas fa-pencil-alt','fas fa-pencil-ruler','fas fa-ruler-combined','fas fa-ruler-horizontal','fas fa-ruler-vertical','fas fa-save','far fa-save','fas fa-splotch','fas fa-spray-can','fas fa-stamp','fas fa-swatchbook','fas fa-tint','fas fa-tint-slash','fas fa-vector-square', ),
					__( 'Editors', 'btnsx' ) => array( 'fas fa-align-center','fas fa-align-justify','fas fa-align-left','fas fa-align-right','fas fa-bold','fas fa-border-all','fas fa-border-none','fas fa-border-style','fas fa-clipboard','far fa-clipboard','fas fa-clone','far fa-clone','fas fa-columns','fas fa-copy','far fa-copy','fas fa-cut','fas fa-edit','far fa-edit','fas fa-eraser','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-font','fas fa-glasses','fas fa-heading','fas fa-highlighter','fas fa-i-cursor','fas fa-icons','fas fa-indent','fas fa-italic','fas fa-link','fas fa-list','fas fa-list-alt','far fa-list-alt','fas fa-list-ol','fas fa-list-ul','fas fa-marker','fas fa-outdent','fas fa-paper-plane','far fa-paper-plane','fas fa-paperclip','fas fa-paragraph','fas fa-paste','fas fa-pen','fas fa-pen-alt','fas fa-pen-fancy','fas fa-pen-nib','fas fa-pencil-alt','fas fa-print','fas fa-quote-left','fas fa-quote-right','fas fa-redo','fas fa-redo-alt','fas fa-remove-format','fas fa-reply','fas fa-reply-all','fas fa-screwdriver','fas fa-share','fas fa-spell-check','fas fa-strikethrough','fas fa-subscript','fas fa-superscript','fas fa-sync','fas fa-sync-alt','fas fa-table','fas fa-tasks','fas fa-text-height','fas fa-text-width','fas fa-th','fas fa-th-large','fas fa-th-list','fas fa-tools','fas fa-trash','fas fa-trash-alt','far fa-trash-alt','fas fa-trash-restore','fas fa-trash-restore-alt','fas fa-underline','fas fa-undo','fas fa-undo-alt','fas fa-unlink','fas fa-wrench', ),
					__( 'Education', 'btnsx' ) => array( 'fas fa-apple-alt','fas fa-atom','fas fa-award','fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fas fa-book-open','fas fa-book-reader','fas fa-chalkboard','fas fa-chalkboard-teacher','fas fa-graduation-cap','fas fa-laptop-code','fas fa-microscope','fas fa-music','fas fa-school','fas fa-shapes','fas fa-theater-masks','fas fa-user-graduate', ),
					__( 'Emoji', 'btnsx' ) => array( 'fas fa-angry','far fa-angry','fas fa-dizzy','far fa-dizzy','fas fa-flushed','far fa-flushed','fas fa-frown','far fa-frown','fas fa-frown-open','far fa-frown-open','fas fa-grimace','far fa-grimace','fas fa-grin','far fa-grin','fas fa-grin-alt','far fa-grin-alt','fas fa-grin-beam','far fa-grin-beam','fas fa-grin-beam-sweat','far fa-grin-beam-sweat','fas fa-grin-hearts','far fa-grin-hearts','fas fa-grin-squint','far fa-grin-squint','fas fa-grin-squint-tears','far fa-grin-squint-tears','fas fa-grin-stars','far fa-grin-stars','fas fa-grin-tears','far fa-grin-tears','fas fa-grin-tongue','far fa-grin-tongue','fas fa-grin-tongue-squint','far fa-grin-tongue-squint','fas fa-grin-tongue-wink','far fa-grin-tongue-wink','fas fa-grin-wink','far fa-grin-wink','fas fa-kiss','far fa-kiss','fas fa-kiss-beam','far fa-kiss-beam','fas fa-kiss-wink-heart','far fa-kiss-wink-heart','fas fa-laugh','far fa-laugh','fas fa-laugh-beam','far fa-laugh-beam','fas fa-laugh-squint','far fa-laugh-squint','fas fa-laugh-wink','far fa-laugh-wink','fas fa-meh','far fa-meh','fas fa-meh-blank','far fa-meh-blank','fas fa-meh-rolling-eyes','far fa-meh-rolling-eyes','fas fa-sad-cry','far fa-sad-cry','fas fa-sad-tear','far fa-sad-tear','fas fa-smile','far fa-smile','fas fa-smile-beam','far fa-smile-beam','fas fa-smile-wink','far fa-smile-wink','fas fa-surprise','far fa-surprise','fas fa-tired','far fa-tired', ),
					__( 'Energy', 'btnsx' ) => array( 'fas fa-atom','fas fa-battery-empty','fas fa-battery-full','fas fa-battery-half','fas fa-battery-quarter','fas fa-battery-three-quarters','fas fa-broadcast-tower','fas fa-burn','fas fa-charging-station','fas fa-fire','fas fa-fire-alt','fas fa-gas-pump','fas fa-industry','fas fa-leaf','fas fa-lightbulb','far fa-lightbulb','fas fa-plug','fas fa-poop','fas fa-power-off','fas fa-radiation','fas fa-radiation-alt','fas fa-seedling','fas fa-solar-panel','fas fa-sun','far fa-sun','fas fa-water','fas fa-wind', ),
					__( 'Files', 'btnsx' ) => array( 'fas fa-archive','fas fa-clone','far fa-clone','fas fa-copy','far fa-copy','fas fa-cut','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-file-archive','far fa-file-archive','fas fa-file-audio','far fa-file-audio','fas fa-file-code','far fa-file-code','fas fa-file-excel','far fa-file-excel','fas fa-file-image','far fa-file-image','fas fa-file-pdf','far fa-file-pdf','fas fa-file-powerpoint','far fa-file-powerpoint','fas fa-file-video','far fa-file-video','fas fa-file-word','far fa-file-word','fas fa-folder','far fa-folder','fas fa-folder-open','far fa-folder-open','fas fa-paste','fas fa-photo-video','fas fa-save','far fa-save','fas fa-sticky-note','far fa-sticky-note', ),
					__( 'Finance', 'btnsx' ) => array( 'fas fa-balance-scale','fas fa-balance-scale-left','fas fa-balance-scale-right','fas fa-book','fas fa-cash-register','fas fa-chart-line','fas fa-chart-pie','fas fa-coins','fas fa-comment-dollar','fas fa-comments-dollar','fas fa-credit-card','far fa-credit-card','fas fa-donate','fas fa-file-invoice','fas fa-file-invoice-dollar','fas fa-hand-holding-usd','fas fa-landmark','fas fa-money-bill','fas fa-money-bill-alt','far fa-money-bill-alt','fas fa-money-bill-wave','fas fa-money-bill-wave-alt','fas fa-money-check','fas fa-money-check-alt','fas fa-percentage','fas fa-piggy-bank','fas fa-receipt','fas fa-stamp','fas fa-wallet', ),
					__( 'Fitness', 'btnsx' ) => array( 'fas fa-bicycle','fas fa-biking','fas fa-burn','fas fa-fire-alt','fas fa-heart','far fa-heart','fas fa-heartbeat','fas fa-hiking','fas fa-running','fas fa-shoe-prints','fas fa-skating','fas fa-skiing','fas fa-skiing-nordic','fas fa-snowboarding','fas fa-spa','fas fa-swimmer','fas fa-walking', ),
					__( 'Food', 'btnsx' ) => array( 'fas fa-apple-alt','fas fa-bacon','fas fa-bone','fas fa-bread-slice','fas fa-candy-cane','fas fa-carrot','fas fa-cheese','fas fa-cloud-meatball','fas fa-cookie','fas fa-drumstick-bite','fas fa-egg','fas fa-fish','fas fa-hamburger','fas fa-hotdog','fas fa-ice-cream','fas fa-lemon','far fa-lemon','fas fa-pepper-hot','fas fa-pizza-slice','fas fa-seedling','fas fa-stroopwafel', ),
					__( 'Fruits & Vegetables', 'btnsx' ) => array( 'fas fa-apple-alt','fas fa-carrot','fas fa-leaf','fas fa-lemon','far fa-lemon','fas fa-pepper-hot','fas fa-seedling', ),
					__( 'Games', 'btnsx' ) => array( 'fas fa-chess','fas fa-chess-bishop','fas fa-chess-board','fas fa-chess-king','fas fa-chess-knight','fas fa-chess-pawn','fas fa-chess-queen','fas fa-chess-rook','fas fa-dice','fas fa-dice-d20','fas fa-dice-d6','fas fa-dice-five','fas fa-dice-four','fas fa-dice-one','fas fa-dice-six','fas fa-dice-three','fas fa-dice-two','fas fa-gamepad','fas fa-ghost','fas fa-headset','fas fa-heart','far fa-heart','fab fa-playstation','fas fa-puzzle-piece','fab fa-steam','fab fa-steam-square','fab fa-steam-symbol','fab fa-twitch','fab fa-xbox', ),
					__( 'Genders', 'btnsx' ) => array( 'fas fa-genderless','fas fa-mars','fas fa-mars-double','fas fa-mars-stroke','fas fa-mars-stroke-h','fas fa-mars-stroke-v','fas fa-mercury','fas fa-neuter','fas fa-transgender','fas fa-transgender-alt','fas fa-venus','fas fa-venus-double','fas fa-venus-mars', ),
					__( 'Halloween', 'btnsx' ) => array( 'fas fa-book-dead','fas fa-broom','fas fa-cat','fas fa-cloud-moon','fas fa-crow','fas fa-ghost','fas fa-hat-wizard','fas fa-mask','fas fa-skull-crossbones','fas fa-spider','fas fa-toilet-paper', ),
					__( 'Hands', 'btnsx' ) => array( 'fas fa-allergies','fas fa-fist-raised','fas fa-hand-holding','fas fa-hand-holding-heart','fas fa-hand-holding-usd','fas fa-hand-lizard','far fa-hand-lizard','fas fa-hand-middle-finger','fas fa-hand-paper','far fa-hand-paper','fas fa-hand-peace','far fa-hand-peace','fas fa-hand-point-down','far fa-hand-point-down','fas fa-hand-point-left','far fa-hand-point-left','fas fa-hand-point-right','far fa-hand-point-right','fas fa-hand-point-up','far fa-hand-point-up','fas fa-hand-pointer','far fa-hand-pointer','fas fa-hand-rock','far fa-hand-rock','fas fa-hand-scissors','far fa-hand-scissors','fas fa-hand-spock','far fa-hand-spock','fas fa-hands','fas fa-hands-helping','fas fa-handshake','far fa-handshake','fas fa-praying-hands','fas fa-thumbs-down','far fa-thumbs-down','fas fa-thumbs-up','far fa-thumbs-up', ),
					__( 'Health', 'btnsx' ) => array( 'fab fa-accessible-icon','fas fa-ambulance','fas fa-h-square','fas fa-heart','far fa-heart','fas fa-heartbeat','fas fa-hospital','far fa-hospital','fas fa-medkit','fas fa-plus-square','far fa-plus-square','fas fa-prescription','fas fa-stethoscope','fas fa-user-md','fas fa-wheelchair', ),
					__( 'Holiday', 'btnsx' ) => array( 'fas fa-candy-cane','fas fa-carrot','fas fa-cookie-bite','fas fa-gift','fas fa-gifts','fas fa-glass-cheers','fas fa-holly-berry','fas fa-mug-hot','fas fa-sleigh','fas fa-snowman', ),
					__( 'Hotel', 'btnsx' ) => array( 'fas fa-baby-carriage','fas fa-bath','fas fa-bed','fas fa-briefcase','fas fa-car','fas fa-cocktail','fas fa-coffee','fas fa-concierge-bell','fas fa-dice','fas fa-dice-five','fas fa-door-closed','fas fa-door-open','fas fa-dumbbell','fas fa-glass-martini','fas fa-glass-martini-alt','fas fa-hot-tub','fas fa-hotel','fas fa-infinity','fas fa-key','fas fa-luggage-cart','fas fa-shower','fas fa-shuttle-van','fas fa-smoking','fas fa-smoking-ban','fas fa-snowflake','far fa-snowflake','fas fa-spa','fas fa-suitcase','fas fa-suitcase-rolling','fas fa-swimmer','fas fa-swimming-pool','fas fa-tv','fas fa-umbrella-beach','fas fa-utensils','fas fa-wheelchair','fas fa-wifi', ),
					__( 'Household', 'btnsx' ) => array( 'fas fa-bath','fas fa-bed','fas fa-blender','fas fa-chair','fas fa-couch','fas fa-door-closed','fas fa-door-open','fas fa-dungeon','fas fa-fan','fas fa-shower','fas fa-toilet-paper','fas fa-tv', ),
					__( 'Images', 'btnsx' ) => array( 'fas fa-adjust','fas fa-bolt','fas fa-camera','fas fa-camera-retro','fas fa-chalkboard','fas fa-clone','far fa-clone','fas fa-compress','fas fa-compress-arrows-alt','fas fa-expand','fas fa-eye','far fa-eye','fas fa-eye-dropper','fas fa-eye-slash','far fa-eye-slash','fas fa-file-image','far fa-file-image','fas fa-film','fas fa-id-badge','far fa-id-badge','fas fa-id-card','far fa-id-card','fas fa-image','far fa-image','fas fa-images','far fa-images','fas fa-photo-video','fas fa-portrait','fas fa-sliders-h','fas fa-tint', ),
					__( 'Interfaces', 'btnsx' ) => array( 'fas fa-award','fas fa-ban','fas fa-barcode','fas fa-bars','fas fa-beer','fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fas fa-blog','fas fa-bug','fas fa-bullhorn','fas fa-bullseye','fas fa-calculator','fas fa-calendar','far fa-calendar','fas fa-calendar-alt','far fa-calendar-alt','fas fa-calendar-check','far fa-calendar-check','fas fa-calendar-minus','far fa-calendar-minus','fas fa-calendar-plus','far fa-calendar-plus','fas fa-calendar-times','far fa-calendar-times','fas fa-certificate','fas fa-check','fas fa-check-circle','far fa-check-circle','fas fa-check-double','fas fa-check-square','far fa-check-square','fas fa-circle','far fa-circle','fas fa-clipboard','far fa-clipboard','fas fa-clone','far fa-clone','fas fa-cloud','fas fa-cloud-download-alt','fas fa-cloud-upload-alt','fas fa-coffee','fas fa-cog','fas fa-cogs','fas fa-copy','far fa-copy','fas fa-cut','fas fa-database','fas fa-dot-circle','far fa-dot-circle','fas fa-download','fas fa-edit','far fa-edit','fas fa-ellipsis-h','fas fa-ellipsis-v','fas fa-envelope','far fa-envelope','fas fa-envelope-open','far fa-envelope-open','fas fa-eraser','fas fa-exclamation','fas fa-exclamation-circle','fas fa-exclamation-triangle','fas fa-external-link-alt','fas fa-external-link-square-alt','fas fa-eye','far fa-eye','fas fa-eye-slash','far fa-eye-slash','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-file-download','fas fa-file-export','fas fa-file-import','fas fa-file-upload','fas fa-filter','fas fa-fingerprint','fas fa-flag','far fa-flag','fas fa-flag-checkered','fas fa-folder','far fa-folder','fas fa-folder-open','far fa-folder-open','fas fa-frown','far fa-frown','fas fa-glasses','fas fa-grip-horizontal','fas fa-grip-lines','fas fa-grip-lines-vertical','fas fa-grip-vertical','fas fa-hashtag','fas fa-heart','far fa-heart','fas fa-history','fas fa-home','fas fa-i-cursor','fas fa-info','fas fa-info-circle','fas fa-language','fas fa-magic','fas fa-marker','fas fa-medal','fas fa-meh','far fa-meh','fas fa-microphone','fas fa-microphone-alt','fas fa-microphone-slash','fas fa-minus','fas fa-minus-circle','fas fa-minus-square','far fa-minus-square','fas fa-paste','fas fa-pen','fas fa-pen-alt','fas fa-pen-fancy','fas fa-pencil-alt','fas fa-plus','fas fa-plus-circle','fas fa-plus-square','far fa-plus-square','fas fa-poo','fas fa-qrcode','fas fa-question','fas fa-question-circle','far fa-question-circle','fas fa-quote-left','fas fa-quote-right','fas fa-redo','fas fa-redo-alt','fas fa-reply','fas fa-reply-all','fas fa-rss','fas fa-rss-square','fas fa-save','far fa-save','fas fa-screwdriver','fas fa-search','fas fa-search-minus','fas fa-search-plus','fas fa-share','fas fa-share-alt','fas fa-share-alt-square','fas fa-share-square','far fa-share-square','fas fa-shield-alt','fas fa-sign-in-alt','fas fa-sign-out-alt','fas fa-signal','fas fa-sitemap','fas fa-sliders-h','fas fa-smile','far fa-smile','fas fa-sort','fas fa-sort-alpha-down','fas fa-sort-alpha-down-alt','fas fa-sort-alpha-up','fas fa-sort-alpha-up-alt','fas fa-sort-amount-down','fas fa-sort-amount-down-alt','fas fa-sort-amount-up','fas fa-sort-amount-up-alt','fas fa-sort-down','fas fa-sort-numeric-down','fas fa-sort-numeric-down-alt','fas fa-sort-numeric-up','fas fa-sort-numeric-up-alt','fas fa-sort-up','fas fa-star','far fa-star','fas fa-star-half','far fa-star-half','fas fa-sync','fas fa-sync-alt','fas fa-thumbs-down','far fa-thumbs-down','fas fa-thumbs-up','far fa-thumbs-up','fas fa-times','fas fa-times-circle','far fa-times-circle','fas fa-toggle-off','fas fa-toggle-on','fas fa-tools','fas fa-trash','fas fa-trash-alt','far fa-trash-alt','fas fa-trash-restore','fas fa-trash-restore-alt','fas fa-trophy','fas fa-undo','fas fa-undo-alt','fas fa-upload','fas fa-user','far fa-user','fas fa-user-alt','fas fa-user-circle','far fa-user-circle','fas fa-volume-down','fas fa-volume-mute','fas fa-volume-off','fas fa-volume-up','fas fa-wifi','fas fa-wrench', ),
					__( 'Logistics', 'btnsx' ) => array( 'fas fa-box','fas fa-boxes','fas fa-clipboard-check','fas fa-clipboard-list','fas fa-dolly','fas fa-dolly-flatbed','fas fa-hard-hat','fas fa-pallet','fas fa-shipping-fast','fas fa-truck','fas fa-warehouse', ),
					__( 'Maps', 'btnsx' ) => array( 'fas fa-ambulance','fas fa-anchor','fas fa-balance-scale','fas fa-balance-scale-left','fas fa-balance-scale-right','fas fa-bath','fas fa-bed','fas fa-beer','fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fas fa-bicycle','fas fa-binoculars','fas fa-birthday-cake','fas fa-blind','fas fa-bomb','fas fa-book','fas fa-bookmark','far fa-bookmark','fas fa-briefcase','fas fa-building','far fa-building','fas fa-car','fas fa-coffee','fas fa-crosshairs','fas fa-directions','fas fa-dollar-sign','fas fa-draw-polygon','fas fa-eye','far fa-eye','fas fa-eye-slash','far fa-eye-slash','fas fa-fighter-jet','fas fa-fire','fas fa-fire-alt','fas fa-fire-extinguisher','fas fa-flag','far fa-flag','fas fa-flag-checkered','fas fa-flask','fas fa-gamepad','fas fa-gavel','fas fa-gift','fas fa-glass-martini','fas fa-globe','fas fa-graduation-cap','fas fa-h-square','fas fa-heart','far fa-heart','fas fa-heartbeat','fas fa-helicopter','fas fa-home','fas fa-hospital','far fa-hospital','fas fa-image','far fa-image','fas fa-images','far fa-images','fas fa-industry','fas fa-info','fas fa-info-circle','fas fa-key','fas fa-landmark','fas fa-layer-group','fas fa-leaf','fas fa-lemon','far fa-lemon','fas fa-life-ring','far fa-life-ring','fas fa-lightbulb','far fa-lightbulb','fas fa-location-arrow','fas fa-low-vision','fas fa-magnet','fas fa-male','fas fa-map','far fa-map','fas fa-map-marker','fas fa-map-marker-alt','fas fa-map-pin','fas fa-map-signs','fas fa-medkit','fas fa-money-bill','fas fa-money-bill-alt','far fa-money-bill-alt','fas fa-motorcycle','fas fa-music','fas fa-newspaper','far fa-newspaper','fas fa-parking','fas fa-paw','fas fa-phone','fas fa-phone-alt','fas fa-phone-square','fas fa-phone-square-alt','fas fa-phone-volume','fas fa-plane','fas fa-plug','fas fa-plus','fas fa-plus-square','far fa-plus-square','fas fa-print','fas fa-recycle','fas fa-restroom','fas fa-road','fas fa-rocket','fas fa-route','fas fa-search','fas fa-search-minus','fas fa-search-plus','fas fa-ship','fas fa-shoe-prints','fas fa-shopping-bag','fas fa-shopping-basket','fas fa-shopping-cart','fas fa-shower','fas fa-snowplow','fas fa-street-view','fas fa-subway','fas fa-suitcase','fas fa-tag','fas fa-tags','fas fa-taxi','fas fa-thumbtack','fas fa-ticket-alt','fas fa-tint','fas fa-traffic-light','fas fa-train','fas fa-tram','fas fa-tree','fas fa-trophy','fas fa-truck','fas fa-tty','fas fa-umbrella','fas fa-university','fas fa-utensil-spoon','fas fa-utensils','fas fa-wheelchair','fas fa-wifi','fas fa-wine-glass','fas fa-wrench', ),
					__( 'Maritime', 'btnsx' ) => array( 'fas fa-anchor','fas fa-binoculars','fas fa-compass','far fa-compass','fas fa-dharmachakra','fas fa-frog','fas fa-ship','fas fa-skull-crossbones','fas fa-swimmer','fas fa-water','fas fa-wind', ),
					__( 'Marketing', 'btnsx' ) => array( 'fas fa-ad','fas fa-bullhorn','fas fa-bullseye','fas fa-comment-dollar','fas fa-comments-dollar','fas fa-envelope-open-text','fas fa-funnel-dollar','fas fa-lightbulb','far fa-lightbulb','fas fa-mail-bulk','fas fa-poll','fas fa-poll-h','fas fa-search-dollar','fas fa-search-location', ),
					__( 'Mathematics', 'btnsx' ) => array( 'fas fa-calculator','fas fa-divide','fas fa-equals','fas fa-greater-than','fas fa-greater-than-equal','fas fa-infinity','fas fa-less-than','fas fa-less-than-equal','fas fa-minus','fas fa-not-equal','fas fa-percentage','fas fa-plus','fas fa-square-root-alt','fas fa-subscript','fas fa-superscript','fas fa-times','fas fa-wave-square', ),
					__( 'Medical', 'btnsx' ) => array( 'fas fa-allergies','fas fa-ambulance','fas fa-band-aid','fas fa-biohazard','fas fa-bone','fas fa-bong','fas fa-book-medical','fas fa-brain','fas fa-briefcase-medical','fas fa-burn','fas fa-cannabis','fas fa-capsules','fas fa-clinic-medical','fas fa-comment-medical','fas fa-crutch','fas fa-diagnoses','fas fa-dna','fas fa-file-medical','fas fa-file-medical-alt','fas fa-file-prescription','fas fa-first-aid','fas fa-heart','far fa-heart','fas fa-heartbeat','fas fa-hospital','far fa-hospital','fas fa-hospital-alt','fas fa-hospital-symbol','fas fa-id-card-alt','fas fa-joint','fas fa-laptop-medical','fas fa-microscope','fas fa-mortar-pestle','fas fa-notes-medical','fas fa-pager','fas fa-pills','fas fa-plus','fas fa-poop','fas fa-prescription','fas fa-prescription-bottle','fas fa-prescription-bottle-alt','fas fa-procedures','fas fa-radiation','fas fa-radiation-alt','fas fa-smoking','fas fa-smoking-ban','fas fa-star-of-life','fas fa-stethoscope','fas fa-syringe','fas fa-tablets','fas fa-teeth','fas fa-teeth-open','fas fa-thermometer','fas fa-tooth','fas fa-user-md','fas fa-user-nurse','fas fa-vial','fas fa-vials','fas fa-weight','fas fa-x-ray', ),
					__( 'Moving', 'btnsx' ) => array( 'fas fa-archive','fas fa-box-open','fas fa-couch','fas fa-dolly','fas fa-people-carry','fas fa-route','fas fa-sign','fas fa-suitcase','fas fa-tape','fas fa-truck-loading','fas fa-truck-moving','fas fa-wine-glass', ),
					__( 'Music', 'btnsx' ) => array( 'fas fa-drum','fas fa-drum-steelpan','fas fa-file-audio','far fa-file-audio','fas fa-guitar','fas fa-headphones','fas fa-headphones-alt','fas fa-music','fab fa-napster','fas fa-play','fas fa-sliders-h','fab fa-soundcloud','fab fa-spotify','fas fa-volume-down','fas fa-volume-mute','fas fa-volume-off','fas fa-volume-up', ),
					__( 'Objects', 'btnsx' ) => array( 'fas fa-ambulance','fas fa-anchor','fas fa-archive','fas fa-award','fas fa-baby-carriage','fas fa-balance-scale','fas fa-balance-scale-left','fas fa-balance-scale-right','fas fa-bath','fas fa-bed','fas fa-beer','fas fa-bell','far fa-bell','fas fa-bicycle','fas fa-binoculars','fas fa-birthday-cake','fas fa-blender','fas fa-bomb','fas fa-book','fas fa-book-dead','fas fa-bookmark','far fa-bookmark','fas fa-briefcase','fas fa-broadcast-tower','fas fa-bug','fas fa-building','far fa-building','fas fa-bullhorn','fas fa-bullseye','fas fa-bus','fas fa-calculator','fas fa-calendar','far fa-calendar','fas fa-calendar-alt','far fa-calendar-alt','fas fa-camera','fas fa-camera-retro','fas fa-candy-cane','fas fa-car','fas fa-carrot','fas fa-church','fas fa-clipboard','far fa-clipboard','fas fa-cloud','fas fa-coffee','fas fa-cog','fas fa-cogs','fas fa-compass','far fa-compass','fas fa-cookie','fas fa-cookie-bite','fas fa-copy','far fa-copy','fas fa-cube','fas fa-cubes','fas fa-cut','fas fa-dice','fas fa-dice-d20','fas fa-dice-d6','fas fa-dice-five','fas fa-dice-four','fas fa-dice-one','fas fa-dice-six','fas fa-dice-three','fas fa-dice-two','fas fa-digital-tachograph','fas fa-door-closed','fas fa-door-open','fas fa-drum','fas fa-drum-steelpan','fas fa-envelope','far fa-envelope','fas fa-envelope-open','far fa-envelope-open','fas fa-eraser','fas fa-eye','far fa-eye','fas fa-eye-dropper','fas fa-fax','fas fa-feather','fas fa-feather-alt','fas fa-fighter-jet','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-file-prescription','fas fa-film','fas fa-fire','fas fa-fire-alt','fas fa-fire-extinguisher','fas fa-flag','far fa-flag','fas fa-flag-checkered','fas fa-flask','fas fa-futbol','far fa-futbol','fas fa-gamepad','fas fa-gavel','fas fa-gem','far fa-gem','fas fa-gift','fas fa-gifts','fas fa-glass-cheers','fas fa-glass-martini','fas fa-glass-whiskey','fas fa-glasses','fas fa-globe','fas fa-graduation-cap','fas fa-guitar','fas fa-hat-wizard','fas fa-hdd','far fa-hdd','fas fa-headphones','fas fa-headphones-alt','fas fa-headset','fas fa-heart','far fa-heart','fas fa-heart-broken','fas fa-helicopter','fas fa-highlighter','fas fa-holly-berry','fas fa-home','fas fa-hospital','far fa-hospital','fas fa-hourglass','far fa-hourglass','fas fa-igloo','fas fa-image','far fa-image','fas fa-images','far fa-images','fas fa-industry','fas fa-key','fas fa-keyboard','far fa-keyboard','fas fa-laptop','fas fa-leaf','fas fa-lemon','far fa-lemon','fas fa-life-ring','far fa-life-ring','fas fa-lightbulb','far fa-lightbulb','fas fa-lock','fas fa-lock-open','fas fa-magic','fas fa-magnet','fas fa-map','far fa-map','fas fa-map-marker','fas fa-map-marker-alt','fas fa-map-pin','fas fa-map-signs','fas fa-marker','fas fa-medal','fas fa-medkit','fas fa-memory','fas fa-microchip','fas fa-microphone','fas fa-microphone-alt','fas fa-mitten','fas fa-mobile','fas fa-mobile-alt','fas fa-money-bill','fas fa-money-bill-alt','far fa-money-bill-alt','fas fa-money-check','fas fa-money-check-alt','fas fa-moon','far fa-moon','fas fa-motorcycle','fas fa-mug-hot','fas fa-newspaper','far fa-newspaper','fas fa-paint-brush','fas fa-paper-plane','far fa-paper-plane','fas fa-paperclip','fas fa-paste','fas fa-paw','fas fa-pen','fas fa-pen-alt','fas fa-pen-fancy','fas fa-pen-nib','fas fa-pencil-alt','fas fa-phone','fas fa-phone-alt','fas fa-plane','fas fa-plug','fas fa-print','fas fa-puzzle-piece','fas fa-ring','fas fa-road','fas fa-rocket','fas fa-ruler-combined','fas fa-ruler-horizontal','fas fa-ruler-vertical','fas fa-satellite','fas fa-satellite-dish','fas fa-save','far fa-save','fas fa-school','fas fa-screwdriver','fas fa-scroll','fas fa-sd-card','fas fa-search','fas fa-shield-alt','fas fa-shopping-bag','fas fa-shopping-basket','fas fa-shopping-cart','fas fa-shower','fas fa-sim-card','fas fa-skull-crossbones','fas fa-sleigh','fas fa-snowflake','far fa-snowflake','fas fa-snowplow','fas fa-space-shuttle','fas fa-star','far fa-star','fas fa-sticky-note','far fa-sticky-note','fas fa-stopwatch','fas fa-stroopwafel','fas fa-subway','fas fa-suitcase','fas fa-sun','far fa-sun','fas fa-tablet','fas fa-tablet-alt','fas fa-tachometer-alt','fas fa-tag','fas fa-tags','fas fa-taxi','fas fa-thumbtack','fas fa-ticket-alt','fas fa-toilet','fas fa-toolbox','fas fa-tools','fas fa-train','fas fa-tram','fas fa-trash','fas fa-trash-alt','far fa-trash-alt','fas fa-tree','fas fa-trophy','fas fa-truck','fas fa-tv','fas fa-umbrella','fas fa-university','fas fa-unlock', ),
					__( 'Payments & Shopping', 'btnsx' ) => array( 'fab fa-alipay','fab fa-amazon-pay','fab fa-apple-pay','fas fa-bell','far fa-bell','fab fa-bitcoin','fas fa-bookmark','far fa-bookmark','fab fa-btc','fas fa-bullhorn','fas fa-camera','fas fa-camera-retro','fas fa-cart-arrow-down','fas fa-cart-plus','fab fa-cc-amazon-pay','fab fa-cc-amex','fab fa-cc-apple-pay','fab fa-cc-diners-club','fab fa-cc-discover','fab fa-cc-jcb','fab fa-cc-mastercard','fab fa-cc-paypal','fab fa-cc-stripe','fab fa-cc-visa','fas fa-certificate','fas fa-credit-card','far fa-credit-card','fab fa-ethereum','fas fa-gem','far fa-gem','fas fa-gift','fab fa-google-wallet','fas fa-handshake','far fa-handshake','fas fa-heart','far fa-heart','fas fa-key','fas fa-money-check','fas fa-money-check-alt','fab fa-paypal','fas fa-receipt','fas fa-shopping-bag','fas fa-shopping-basket','fas fa-shopping-cart','fas fa-star','far fa-star','fab fa-stripe','fab fa-stripe-s','fas fa-tag','fas fa-tags','fas fa-thumbs-down','far fa-thumbs-down','fas fa-thumbs-up','far fa-thumbs-up','fas fa-trophy', ),
					__( 'Pharmacy', 'btnsx' ) => array( 'fas fa-band-aid','fas fa-book-medical','fas fa-cannabis','fas fa-capsules','fas fa-clinic-medical','fas fa-eye-dropper','fas fa-file-medical','fas fa-file-prescription','fas fa-first-aid','fas fa-flask','fas fa-history','fas fa-joint','fas fa-laptop-medical','fas fa-mortar-pestle','fas fa-notes-medical','fas fa-pills','fas fa-prescription','fas fa-prescription-bottle','fas fa-prescription-bottle-alt','fas fa-receipt','fas fa-skull-crossbones','fas fa-syringe','fas fa-tablets','fas fa-thermometer','fas fa-vial','fas fa-vials', ),
					__( 'Political', 'btnsx' ) => array( 'fas fa-award','fas fa-balance-scale','fas fa-balance-scale-left','fas fa-balance-scale-right','fas fa-bullhorn','fas fa-check-double','fas fa-democrat','fas fa-donate','fas fa-dove','fas fa-fist-raised','fas fa-flag-usa','fas fa-handshake','far fa-handshake','fas fa-person-booth','fas fa-piggy-bank','fas fa-republican','fas fa-vote-yea', ),
					__( 'Religion', 'btnsx' ) => array( 'fas fa-ankh','fas fa-atom','fas fa-bible','fas fa-church','fas fa-cross','fas fa-dharmachakra','fas fa-dove','fas fa-gopuram','fas fa-hamsa','fas fa-hanukiah','fas fa-haykal','fas fa-jedi','fas fa-journal-whills','fas fa-kaaba','fas fa-khanda','fas fa-menorah','fas fa-mosque','fas fa-om','fas fa-pastafarianism','fas fa-peace','fas fa-place-of-worship','fas fa-pray','fas fa-praying-hands','fas fa-quran','fas fa-star-and-crescent','fas fa-star-of-david','fas fa-synagogue','fas fa-torah','fas fa-torii-gate','fas fa-vihara','fas fa-yin-yang', ),
					__( 'Science', 'btnsx' ) => array( 'fas fa-atom','fas fa-biohazard','fas fa-brain','fas fa-burn','fas fa-capsules','fas fa-clipboard-check','fas fa-dna','fas fa-eye-dropper','fas fa-filter','fas fa-fire','fas fa-fire-alt','fas fa-flask','fas fa-frog','fas fa-magnet','fas fa-microscope','fas fa-mortar-pestle','fas fa-pills','fas fa-prescription-bottle','fas fa-radiation','fas fa-radiation-alt','fas fa-seedling','fas fa-skull-crossbones','fas fa-syringe','fas fa-tablets','fas fa-temperature-high','fas fa-temperature-low','fas fa-vial','fas fa-vials', ),
					__( 'Science Fiction', 'btnsx' ) => array( 'fab fa-galactic-republic','fab fa-galactic-senate','fas fa-globe','fas fa-jedi','fab fa-jedi-order','fas fa-journal-whills','fas fa-meteor','fas fa-moon','far fa-moon','fab fa-old-republic','fas fa-robot','fas fa-rocket','fas fa-satellite','fas fa-satellite-dish','fas fa-space-shuttle','fas fa-user-astronaut', ),
					__( 'Security', 'btnsx' ) => array( 'fas fa-ban','fas fa-bug','fas fa-door-closed','fas fa-door-open','fas fa-dungeon','fas fa-eye','far fa-eye','fas fa-eye-slash','far fa-eye-slash','fas fa-file-contract','fas fa-file-signature','fas fa-fingerprint','fas fa-id-badge','far fa-id-badge','fas fa-id-card','far fa-id-card','fas fa-id-card-alt','fas fa-key','fas fa-lock','fas fa-lock-open','fas fa-mask','fas fa-passport','fas fa-shield-alt','fas fa-unlock','fas fa-unlock-alt','fas fa-user-lock','fas fa-user-secret','fas fa-user-shield', ),
					__( 'Shapes', 'btnsx' ) => array( 'fas fa-bookmark','far fa-bookmark','fas fa-calendar','far fa-calendar','fas fa-certificate','fas fa-circle','far fa-circle','fas fa-cloud','fas fa-comment','far fa-comment','fas fa-file','far fa-file','fas fa-folder','far fa-folder','fas fa-heart','far fa-heart','fas fa-heart-broken','fas fa-map-marker','fas fa-play','fas fa-shapes','fas fa-square','far fa-square','fas fa-star','far fa-star', ),
					__( 'Shopping', 'btnsx' ) => array( 'fas fa-barcode','fas fa-cart-arrow-down','fas fa-cart-plus','fas fa-cash-register','fas fa-gift','fas fa-gifts','fas fa-person-booth','fas fa-receipt','fas fa-shipping-fast','fas fa-shopping-bag','fas fa-shopping-basket','fas fa-shopping-cart','fas fa-store','fas fa-store-alt','fas fa-truck','fas fa-tshirt', ),
					__( 'Social', 'btnsx' ) => array( 'fas fa-bell','far fa-bell','fas fa-birthday-cake','fas fa-camera','fas fa-comment','far fa-comment','fas fa-comment-alt','far fa-comment-alt','fas fa-envelope','far fa-envelope','fas fa-hashtag','fas fa-heart','far fa-heart','fas fa-icons','fas fa-image','far fa-image','fas fa-images','far fa-images','fas fa-map-marker','fas fa-map-marker-alt','fas fa-photo-video','fas fa-poll','fas fa-poll-h','fas fa-retweet','fas fa-share','fas fa-share-alt','fas fa-share-square','far fa-share-square','fas fa-star','far fa-star','fas fa-thumbs-down','far fa-thumbs-down','fas fa-thumbs-up','far fa-thumbs-up','fas fa-thumbtack','fas fa-user','far fa-user','fas fa-user-circle','far fa-user-circle','fas fa-user-friends','fas fa-user-plus','fas fa-users','fas fa-video', ),
					__( 'Spinners', 'btnsx' ) => array( 'fas fa-asterisk','fas fa-atom','fas fa-certificate','fas fa-circle-notch','fas fa-cog','fas fa-compact-disc','fas fa-compass','far fa-compass','fas fa-crosshairs','fas fa-dharmachakra','fas fa-fan','fas fa-haykal','fas fa-life-ring','far fa-life-ring','fas fa-palette','fas fa-ring','fas fa-slash','fas fa-snowflake','far fa-snowflake','fas fa-spinner','fas fa-stroopwafel','fas fa-sun','far fa-sun','fas fa-sync','fas fa-sync-alt','fas fa-yin-yang', ),
					__( 'Sports', 'btnsx' ) => array( 'fas fa-baseball-ball','fas fa-basketball-ball','fas fa-biking','fas fa-bowling-ball','fas fa-dumbbell','fas fa-football-ball','fas fa-futbol','far fa-futbol','fas fa-golf-ball','fas fa-hockey-puck','fas fa-quidditch','fas fa-running','fas fa-skating','fas fa-skiing','fas fa-skiing-nordic','fas fa-snowboarding','fas fa-swimmer','fas fa-table-tennis','fas fa-volleyball-ball', ),
					__( 'Spring', 'btnsx' ) => array( 'fas fa-allergies','fas fa-broom','fas fa-cloud-sun','fas fa-cloud-sun-rain','fas fa-frog','fas fa-rainbow','fas fa-seedling','fas fa-umbrella', ),
					__( 'Status', 'btnsx' ) => array( 'fas fa-ban','fas fa-battery-empty','fas fa-battery-full','fas fa-battery-half','fas fa-battery-quarter','fas fa-battery-three-quarters','fas fa-bell','far fa-bell','fas fa-bell-slash','far fa-bell-slash','fas fa-calendar','far fa-calendar','fas fa-calendar-alt','far fa-calendar-alt','fas fa-calendar-check','far fa-calendar-check','fas fa-calendar-day','fas fa-calendar-minus','far fa-calendar-minus','fas fa-calendar-plus','far fa-calendar-plus','fas fa-calendar-times','far fa-calendar-times','fas fa-calendar-week','fas fa-cart-arrow-down','fas fa-cart-plus','fas fa-comment','far fa-comment','fas fa-comment-alt','far fa-comment-alt','fas fa-comment-slash','fas fa-compass','far fa-compass','fas fa-door-closed','fas fa-door-open','fas fa-exclamation','fas fa-exclamation-circle','fas fa-exclamation-triangle','fas fa-eye','far fa-eye','fas fa-eye-slash','far fa-eye-slash','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-folder','far fa-folder','fas fa-folder-open','far fa-folder-open','fas fa-gas-pump','fas fa-info','fas fa-info-circle','fas fa-lightbulb','far fa-lightbulb','fas fa-lock','fas fa-lock-open','fas fa-map-marker','fas fa-map-marker-alt','fas fa-microphone','fas fa-microphone-alt','fas fa-microphone-alt-slash','fas fa-microphone-slash','fas fa-minus','fas fa-minus-circle','fas fa-minus-square','far fa-minus-square','fas fa-parking','fas fa-phone','fas fa-phone-alt','fas fa-phone-slash','fas fa-plus','fas fa-plus-circle','fas fa-plus-square','far fa-plus-square','fas fa-print','fas fa-question','fas fa-question-circle','far fa-question-circle','fas fa-shield-alt','fas fa-shopping-cart','fas fa-sign-in-alt','fas fa-sign-out-alt','fas fa-signal','fas fa-smoking-ban','fas fa-star','far fa-star','fas fa-star-half','far fa-star-half','fas fa-star-half-alt','fas fa-stream','fas fa-thermometer-empty','fas fa-thermometer-full','fas fa-thermometer-half','fas fa-thermometer-quarter','fas fa-thermometer-three-quarters','fas fa-thumbs-down','far fa-thumbs-down','fas fa-thumbs-up','far fa-thumbs-up','fas fa-tint','fas fa-tint-slash','fas fa-toggle-off','fas fa-toggle-on','fas fa-unlock','fas fa-unlock-alt','fas fa-user','far fa-user','fas fa-user-alt','fas fa-user-alt-slash','fas fa-user-slash','fas fa-video','fas fa-video-slash','fas fa-volume-down','fas fa-volume-mute','fas fa-volume-off','fas fa-volume-up','fas fa-wifi', ),
					__( 'Summer', 'btnsx' ) => array( 'fas fa-anchor','fas fa-biking','fas fa-fish','fas fa-hotdog','fas fa-ice-cream','fas fa-lemon','far fa-lemon','fas fa-sun','far fa-sun','fas fa-swimmer','fas fa-swimming-pool','fas fa-umbrella-beach','fas fa-volleyball-ball','fas fa-water', ),
					__( 'Tabletop Gaming', 'btnsx' ) => array( 'fab fa-acquisitions-incorporated','fas fa-book-dead','fab fa-critical-role','fab fa-d-and-d','fab fa-d-and-d-beyond','fas fa-dice-d20','fas fa-dice-d6','fas fa-dragon','fas fa-dungeon','fab fa-fantasy-flight-games','fas fa-fist-raised','fas fa-hat-wizard','fab fa-penny-arcade','fas fa-ring','fas fa-scroll','fas fa-skull-crossbones','fab fa-wizards-of-the-coast', ),
					__( 'Toggle', 'btnsx' ) => array( 'fas fa-bullseye','fas fa-check-circle','far fa-check-circle','fas fa-circle','far fa-circle','fas fa-dot-circle','far fa-dot-circle','fas fa-star','far fa-star','fas fa-star-half','far fa-star-half','fas fa-star-half-alt','fas fa-toggle-off','fas fa-toggle-on', ),
					__( 'Travel', 'btnsx' ) => array( 'fas fa-archway','fas fa-atlas','fas fa-bed','fas fa-bus','fas fa-bus-alt','fas fa-cocktail','fas fa-concierge-bell','fas fa-dumbbell','fas fa-glass-martini','fas fa-glass-martini-alt','fas fa-globe-africa','fas fa-globe-americas','fas fa-globe-asia','fas fa-globe-europe','fas fa-hot-tub','fas fa-hotel','fas fa-luggage-cart','fas fa-map','far fa-map','fas fa-map-marked','fas fa-map-marked-alt','fas fa-monument','fas fa-passport','fas fa-plane','fas fa-plane-arrival','fas fa-plane-departure','fas fa-shuttle-van','fas fa-spa','fas fa-suitcase','fas fa-suitcase-rolling','fas fa-swimmer','fas fa-swimming-pool','fas fa-taxi','fas fa-tram','fas fa-umbrella-beach','fas fa-wine-glass','fas fa-wine-glass-alt', ),
					__( 'Users & People', 'btnsx' ) => array( 'fab fa-accessible-icon','fas fa-address-book','far fa-address-book','fas fa-address-card','far fa-address-card','fas fa-baby','fas fa-bed','fas fa-biking','fas fa-blind','fas fa-chalkboard-teacher','fas fa-child','fas fa-female','fas fa-frown','far fa-frown','fas fa-hiking','fas fa-id-badge','far fa-id-badge','fas fa-id-card','far fa-id-card','fas fa-id-card-alt','fas fa-male','fas fa-meh','far fa-meh','fas fa-people-carry','fas fa-person-booth','fas fa-poo','fas fa-portrait','fas fa-power-off','fas fa-pray','fas fa-restroom','fas fa-running','fas fa-skating','fas fa-skiing','fas fa-skiing-nordic','fas fa-smile','far fa-smile','fas fa-snowboarding','fas fa-street-view','fas fa-swimmer','fas fa-user','far fa-user','fas fa-user-alt','fas fa-user-alt-slash','fas fa-user-astronaut','fas fa-user-check','fas fa-user-circle','far fa-user-circle','fas fa-user-clock','fas fa-user-cog','fas fa-user-edit','fas fa-user-friends','fas fa-user-graduate','fas fa-user-injured','fas fa-user-lock','fas fa-user-md','fas fa-user-minus','fas fa-user-ninja','fas fa-user-nurse','fas fa-user-plus','fas fa-user-secret','fas fa-user-shield','fas fa-user-slash','fas fa-user-tag','fas fa-user-tie','fas fa-user-times','fas fa-users','fas fa-users-cog','fas fa-walking','fas fa-wheelchair', ),
					__( 'Vehicles', 'btnsx' ) => array( 'fab fa-accessible-icon','fas fa-ambulance','fas fa-baby-carriage','fas fa-bicycle','fas fa-bus','fas fa-bus-alt','fas fa-car','fas fa-car-alt','fas fa-car-crash','fas fa-car-side','fas fa-fighter-jet','fas fa-helicopter','fas fa-horse','fas fa-motorcycle','fas fa-paper-plane','far fa-paper-plane','fas fa-plane','fas fa-rocket','fas fa-ship','fas fa-shopping-cart','fas fa-shuttle-van','fas fa-sleigh','fas fa-snowplow','fas fa-space-shuttle','fas fa-subway','fas fa-taxi','fas fa-tractor','fas fa-train','fas fa-tram','fas fa-truck','fas fa-truck-monster','fas fa-truck-pickup','fas fa-wheelchair', ),
					__( 'Weather', 'btnsx' ) => array( 'fas fa-bolt','fas fa-cloud','fas fa-cloud-meatball','fas fa-cloud-moon','fas fa-cloud-moon-rain','fas fa-cloud-rain','fas fa-cloud-showers-heavy','fas fa-cloud-sun','fas fa-cloud-sun-rain','fas fa-meteor','fas fa-moon','far fa-moon','fas fa-poo-storm','fas fa-rainbow','fas fa-smog','fas fa-snowflake','far fa-snowflake','fas fa-sun','far fa-sun','fas fa-temperature-high','fas fa-temperature-low','fas fa-umbrella','fas fa-water','fas fa-wind', ),
					__( 'Winter', 'btnsx' ) => array( 'fas fa-glass-whiskey','fas fa-icicles','fas fa-igloo','fas fa-mitten','fas fa-skating','fas fa-skiing','fas fa-skiing-nordic','fas fa-snowboarding','fas fa-snowplow','fas fa-tram', ),
					__( 'Writing', 'btnsx' ) => array( 'fas fa-archive','fas fa-blog','fas fa-book','fas fa-bookmark','far fa-bookmark','fas fa-edit','far fa-edit','fas fa-envelope','far fa-envelope','fas fa-envelope-open','far fa-envelope-open','fas fa-eraser','fas fa-file','far fa-file','fas fa-file-alt','far fa-file-alt','fas fa-folder','far fa-folder','fas fa-folder-open','far fa-folder-open','fas fa-keyboard','far fa-keyboard','fas fa-newspaper','far fa-newspaper','fas fa-paper-plane','far fa-paper-plane','fas fa-paperclip','fas fa-paragraph','fas fa-pen','fas fa-pen-alt','fas fa-pen-square','fas fa-pencil-alt','fas fa-quote-left','fas fa-quote-right','fas fa-sticky-note','far fa-sticky-note','fas fa-thumbtack', ),
	    		)
			);
			
			$output = '';
			
			foreach ( $icons as $icon => $label ) {
				$output .= '<optgroup label="' . esc_attr( $icon ) . '">';
				foreach ( $label as $key => $label ) {
					$output .= '<optgroup label="' . esc_attr( $key ) . '">';
					foreach ( $label as $l ) {
						if( $l == $selected ){
							$output .= '<option value="' . esc_attr( $l ) . '" selected>' . sanitize_text_field( $l ) . '</option>';
						}else{
							$output .= '<option value="' . esc_attr( $l ) . '">' . sanitize_text_field( $l ) . '</option>';
						}
					}
				}
			}

			return $output;
		}

		/**
		 * Animate.css as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function icon_animation_options( $selected ){
			$animations = array(
				__( 'Attention Seekers', 'btnsx' ) => array(
					'bounce' => __('Bounce', 'btnsx'),
					'flash' => __('Flash', 'btnsx'),
					'pulse' => __('Pulse', 'btnsx'),
					'shake' => __('Shake', 'btnsx'),
					'tada' => __('Tada', 'btnsx'),
					'swing' => __('Swing', 'btnsx'),
					'wobble' => __('Wobble', 'btnsx')
					),
				__( 'Bouncing Entrances', 'btnsx' ) => array(
					'bounceIn' => __('BounceIn', 'btnsx'),
					'bounceInDown' => __('BounceInDown', 'btnsx'),
					'bounceInLeft' => __('BounceInLeft', 'btnsx'),
					'bounceInRight' => __('BounceInRight', 'btnsx'),
					'bounceInUp' => __('BounceInUp', 'btnsx')
					),
				__( 'Bouncing Exits', 'btnsx' ) => array(
					'bounceOut' => __('BounceOut', 'btnsx'),
					'bounceOutDown' => __('BounceOutDown', 'btnsx'),
					'bounceOutLeft' => __('BounceOutLeft', 'btnsx'),
					'bounceOutRight' => __('BounceOutRight', 'btnsx'),
					'bounceOutUp' => __('BounceOutUp', 'btnsx')
					),
				__( 'Fading Entrances', 'btnsx' ) => array(
					'fadeIn' => __('FadeIn', 'btnsx'),
					'fadeInDown' => __('FadeInDown', 'btnsx'),
					'fadeInDownBig' => __('FadeInDownBig', 'btnsx'),
					'fadeInLeft' => __('FadeInLeft', 'btnsx'),
					'fadeInLeftBig' => __('FadeInLeftBig', 'btnsx'),
					'fadeInRight' => __('FadeInRight', 'btnsx'),
					'fadeInRightBig' => __('FadeInRightBig', 'btnsx'),
					'fadeInUp' => __('FadeInUp', 'btnsx'),
					'fadeInUpBig' => __('FadeInUpBig', 'btnsx'),
					),
				__( 'Fading Exits', 'btnsx' ) => array(
					'fadeOut' => __('FadeOut', 'btnsx'),
					'fadeOutDown' => __('FadeOutDown', 'btnsx'),
					'fadeOutDownBig' => __('FadeOutDownBig', 'btnsx'),
					'fadeOutLeft' => __('FadeOutLeft', 'btnsx'),
					'fadeOutLeftBig' => __('FadeOutLeftBig', 'btnsx'),
					'fadeOutRight' => __('FadeOutRight', 'btnsx'),
					'fadeOutRightBig' => __('FadeOutRightBig', 'btnsx'),
					'fadeOutUp' => __('FadeOutUp', 'btnsx'),
					'fadeOutUpBig' => __('FadeOutUpBig', 'btnsx'),
					),
				__( 'Flippers', 'btnsx' ) => array(
					'flip' => __('Flip', 'btnsx'),
					'flipInX' => __('FlipInX', 'btnsx'),
					'flipInY' => __('FlipInY', 'btnsx'),
					'flipOutX' => __('FlipOutX', 'btnsx'),
					'flipOutY' => __('FlipOutY', 'btnsx')
					),
				__( 'Lightspeed', 'btnsx' ) => array(
					'lightSpeedIn' => __('LightSpeedIn', 'btnsx'),
					'lightSpeedOut' => __('LightSpeedOut', 'btnsx')
					),
				__( 'Rotating Entrances', 'btnsx' ) => array(
					'rotateIn' => __('RotateIn', 'btnsx'),
					'rotateInDownLeft' => __('RotateInDownLeft', 'btnsx'),
					'rotateInDownRight' => __('RotateInDownRight', 'btnsx'),
					'rotateInUpLeft' => __('RotateInUpLeft', 'btnsx'),
					'rotateInUpRight' => __('RotateInUpRight', 'btnsx')
					),
				__( 'Rotating Exits', 'btnsx' ) => array(
					'rotateOut' => __('RotateOut', 'btnsx'),
					'rotateOutDownLeft' => __('RotateOutDownLeft', 'btnsx'),
					'rotateOutDownRight' => __('RotateOutDownRight', 'btnsx'),
					'rotateOutUpLeft' => __('RotateOutUpLeft', 'btnsx'),
					'rotateOutUpRight' => __('RotateOutUpRight', 'btnsx')
					),
				__( 'Specials', 'btnsx' ) => array(
					'hinge' => __('hinge', 'btnsx'),
					'rollIn' => __('rollIn', 'btnsx'),
					'rollOut' => __('rollOut', 'btnsx')
					),
				__( 'Zoom Entrances', 'btnsx' ) => array(
					'zoomIn' => __('ZoomIn', 'btnsx'),
					'zoomInDown' => __('ZoomInDown', 'btnsx'),
					'zoomInLeft' => __('ZoomInLeft', 'btnsx'),
					'zoomInRight' => __('ZoomInRight', 'btnsx'),
					'zoomInUp' => __('ZoomInUp', 'btnsx'),
					),
				__( 'Zoom Exits', 'btnsx' ) => array(
					'zoomOut' => __('ZoomOut', 'btnsx'),
					'zoomOutDown' => __('ZoomOutDown', 'btnsx'),
					'zoomOutLeft' => __('ZoomOutLeft', 'btnsx'),
					'zoomOutRight' => __('ZoomOutRight', 'btnsx'),
					'zoomOutUp' => __('ZoomOutUp', 'btnsx')
					)
			);
			$output = '';
			
			foreach ( $animations as $option => $label ) {
				$output .= '<optgroup label="' . $option . '">';
				foreach ( $label as $k => $l ) {
					if( $k == $selected ){
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					}else{
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				}
			}

			return $output;
		}

		/**
		 * Hover.css as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function animation_options( $selected ){
			$animations = array(
				__( 'HOVER.CSS', 'btnsx' ) => array(
					__( '2D Transitions', 'btnsx' ) => array(
						'hvr-bob' => __('Bob', 'btnsx'),
						'hvr-bounce-in' => __('Bounce In', 'btnsx'),
						'hvr-bounce-out' => __('Bounce Out', 'btnsx'),
						'hvr-buzz' => __('Buzz', 'btnsx'),
						'hvr-buzz-out' => __('Buzz Out', 'btnsx'),
						'hvr-float' => __('Float', 'btnsx'),
						'hvr-grow-rotate' => __('Grow Rotate', 'btnsx'),
						'hvr-hang' => __('Hang', 'btnsx'),
						'hvr-pop' => __('Pop', 'btnsx'),
						'hvr-pulse' => __('Pulse', 'btnsx'),
						'hvr-pulse-grow' => __('Pulse Grow', 'btnsx'),
						'hvr-pulse-shrink' => __('Pulse Shrink', 'btnsx'),
						'hvr-push' => __('Push', 'btnsx'),
						'hvr-rotate' => __('Rotate', 'btnsx'),
						'hvr-shrink' => __('Shrink', 'btnsx'),
						'hvr-sink' => __('Sink', 'btnsx'),
						'hvr-skew' => __('Skew', 'btnsx'),
						'hvr-skew-backward' => __('Skew Backward', 'btnsx'),
						'hvr-skew-forward' => __('Skew Forward', 'btnsx'),
						'hvr-wobble-bottom' => __('Wobble Bottom', 'btnsx'),
						'hvr-wobble-horizontal' => __('Wobble Horizontal', 'btnsx'),
						'hvr-wobble-skew' => __('Wobble Skew', 'btnsx'),
						'hvr-wobble-to-bottom-right' => __('Wobble To Bottom Right', 'btnsx'),
						'hvr-wobble-to-top-right' => __('Wobble To Top Right', 'btnsx'),
						'hvr-wobble-top' => __('Wobble Top', 'btnsx'),
						'hvr-wobble-vertical' => __('Wobble Vertical', 'btnsx'),
						'hvr-grow' => __('Grow', 'btnsx')
					),
					__( 'Background Transitions', 'btnsx' ) => array(
						// 'hvr-back-pulse' => __('Back Pulse', 'btnsx'),
						'hvr-bounce-to-bottom' => __('Bounce To Bottom', 'btnsx'),
						'hvr-bounce-to-left' => __('Bounce To Left', 'btnsx'),
						'hvr-bounce-to-right' => __('Bounce To Right', 'btnsx'),
						'hvr-bounce-to-top' => __('Bounce To Top', 'btnsx'),
						// 'hvr-fade' => __('Fade', 'btnsx'),
						'hvr-radial-in' => __('Radial In', 'btnsx'),
						'hvr-radial-out' => __('Radial Out', 'btnsx'),
						'hvr-rectangle-in' => __('Rectangle In', 'btnsx'),
						'hvr-rectangle-out' => __('Rectangle Out', 'btnsx'),
						'hvr-shutter-in-horizontal' => __('Shutter In Horizontal', 'btnsx'),
						'hvr-shutter-in-vertical' => __('Shutter In Vertical', 'btnsx'),
						'hvr-shutter-out-horizontal' => __('Shutter Out Horizontal', 'btnsx'),
						'hvr-shutter-out-vertical' => __('Shutter Out Vertical', 'btnsx'),
						'hvr-sweep-to-bottom' => __('Sweep To Bottom', 'btnsx'),
						'hvr-sweep-to-left' => __('Sweep To Left', 'btnsx'),
						'hvr-sweep-to-right' => __('Sweep To Right', 'btnsx'),
						'hvr-sweep-to-top' => __('Sweep To Top', 'btnsx')
					),
					// __( 'Icons', 'btnsx' ) => array(
					// 	'hvr-icon-back' => __('Icon Back', 'btnsx'),
					// 	'hvr-icon-bob' => __('Icon Bob', 'btnsx'),
					// 	'hvr-icon-bounce' => __('Icon Bounce', 'btnsx'),
					// 	'hvr-icon-buzz' => __('Icon Buzz', 'btnsx'),
					// 	'hvr-icon-buzz-out' => __('Icon Buzz Out', 'btnsx'),
					// 	'hvr-icon-down' => __('Icon Down', 'btnsx'),
					// 	'hvr-icon-drop' => __('Icon Drop', 'btnsx'),
					// 	'hvr-icon-fade' => __('Icon Fade', 'btnsx'),
					// 	'hvr-icon-float' => __('Icon Fade', 'btnsx'),
					// 	'hvr-icon-float-away' => __('Icon Float Away', 'btnsx'),
					// 	'hvr-icon-forward' => __('Icon Forward', 'btnsx'),
					// 	'hvr-icon-grow' => __('Icon Grow', 'btnsx'),
					// 	'hvr-icon-grow-rotate' => __('Icon Grow Rotate', 'btnsx'),
					// 	'hvr-icon-hang' => __('Icon Hang', 'btnsx'),
					// 	'hvr-icon-pop' => __('Icon Pop', 'btnsx'),
					// 	'hvr-icon-pulse' => __('Icon Pulse', 'btnsx'),
					// 	'hvr-icon-pulse-grow' => __('Icon Pulse Grow', 'btnsx'),
					// 	'hvr-icon-pulse-shrink' => __('Icon Pulse Shrink', 'btnsx'),
					// 	'hvr-icon-push' => __('Icon Push', 'btnsx'),
					// 	'hvr-icon-rotate' => __('Icon Rotate', 'btnsx'),
					// 	'hvr-icon-shrink' => __('Icon Shrink', 'btnsx'),
					// 	'hvr-icon-sink' => __('Icon Sink', 'btnsx'),
					// 	'hvr-icon-sink-away' => __('Icon Sink Away', 'btnsx'),
					// 	'hvr-icon-spin' => __('Icon Spin', 'btnsx'),
					// 	'hvr-icon-up' => __('Icon Up', 'btnsx'),
					// 	'hvr-icon-wobble-horizontal' => __('Icon Wobble Horizontal', 'btnsx'),
					// 	'hvr-icon-wobble-vertical' => __('Icon Wobble Vertical', 'btnsx')
					// ),
					__( 'Border Transitions', 'btnsx' ) => array(
						// 'hvr-border-fade' => __('Border Fade', 'btnsx'),
						// 'hvr-hollow' => __('Hollow', 'btnsx'),
						// 'hvr-outline-in' => __('Outline In', 'btnsx'),
						// 'hvr-outline-out' => __('Outline Out', 'btnsx'),
						'hvr-overline-from-center' => __('Overline From Center', 'btnsx'),
						'hvr-overline-from-left' => __('Overline From Left', 'btnsx'),
						'hvr-overline-from-right' => __('Overline From Right', 'btnsx'),
						'hvr-overline-reveal' => __('Overline Reveal', 'btnsx'),
						// 'hvr-reveal' => __('Reveal', 'btnsx'),
						// 'hvr-ripple-in' => __('Ripple In', 'btnsx'),
						// 'hvr-ripple-out' => __('Ripple Out', 'btnsx'),
						// 'hvr-round-corners' => __('Round Corners', 'btnsx'),
						'hvr-trim' => __('Trim', 'btnsx'),
						'hvr-underline-from-center' => __('Underline From Center', 'btnsx'),
						'hvr-underline-from-left' => __('Underline From Left', 'btnsx'),
						'hvr-underline-from-right' => __('Underline From Right', 'btnsx'),
						'hvr-underline-reveal' => __('Underline Reveal', 'btnsx')
					),
					// __( 'Shadow and Glow Transitions', 'btnsx' ) => array(
						// 'hvr-box-shadow-inset' => __('Box Shadow Inset', 'btnsx'),
						// 'hvr-box-shadow-outset' => __('Box Shadow Outset', 'btnsx'),
						// 'hvr-float-shadow' => __('Float Shadow', 'btnsx'),
						// 'hvr-glow' => __('Glow', 'btnsx'),
						// 'hvr-grow-shadow' => __('Grow Shadow', 'btnsx'),
						// 'hvr-shadow' => __('Shadow', 'btnsx'),
						// 'hvr-shadow-radial' => __('Shadow Radial', 'btnsx')
					// ),
					// __( 'Speech Bubbles', 'btnsx' ) => array(
					// 	'hvr-bubble-bottom' => __('Bubble Bottom', 'btnsx'),
					// 	'hvr-bubble-float-bottom' => __('Bubble Float Bottom', 'btnsx'),
					// 	'hvr-bubble-float-left' => __('Bubble Float Left', 'btnsx'),
					// 	'hvr-bubble-float-right' => __('Bubble Float Right', 'btnsx'),
					// 	'hvr-bubble-float-top' => __('Bubble Float Top', 'btnsx'),
					// 	'hvr-bubble-left' => __('Bubble Left', 'btnsx'),
					// 	'hvr-bubble-right' => __('Bubble Right', 'btnsx'),
					// 	'hvr-bubble-top' => __('Bubble Top', 'btnsx'),
					// ),
					__( 'Curls', 'btnsx' ) => array(
						'hvr-curl-bottom-left' => __('Curl Bottom Left', 'btnsx'),
						'hvr-curl-bottom-right' => __('Curl Bottom Right', 'btnsx'),
						'hvr-curl-top-left' => __('Curl Top Left', 'btnsx'),
						'hvr-curl-top-right' => __('Curl Top Right', 'btnsx'),
					)
				)
			);
			$output = '';
			
			foreach ( $animations as $icon => $label ) {
				$output .= '<optgroup label="' . $icon . '">';
				foreach ( $label as $key => $label ) {
					$output .= '<optgroup label="' . $key . '">';
					foreach ( $label as $k => $l ) {
						if( $k == $selected ){
							$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
						}else{
							$output .= '<option value="' . $k . '">' . $l . '</option>';
						}
					}
				}
			}

			return $output;
		}

		/**
		 * Google WebFonts as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function google_webfonts( $selected ){
			$fonts = json_decode( 
        		file_get_contents( BTNSX__PLUGIN_DIR . 'assets/webfonts.json' ) 
			); // 'https://www.googleapis.com/webfonts/v1/webfonts?key=' . BTNSX__WEBFONTS_API_KEY
			$output = array();
			foreach ($fonts->items as $key => $value) {
				$output[$value->family] = $value->family;
			}
			return $output;
		}

		/**
		 * EDD product id's as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function edd_product_ids( $selected ){
			$output = '';
			$args = array(
                'post_type' => 'download',
                'post_status' => 'publish',
                'posts_per_page' => -1
            );

            $the_query = new WP_Query( $args );

            // The Loop
            if ( $the_query->have_posts() ) {
            	$output .= '<optgroup label="' . __( 'Available Downloads' , 'btnsx' ) . '">';
            	// var_dump(get_the_id());
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();
                    if ( isset( $selected ) && $selected == get_the_id() ) {
                        $output .= '<option value="' . get_the_id() . '" selected="selected">' . get_the_title() . '</option>';
                    }else{
                        $output .= '<option value="' . get_the_id() . '">' . get_the_title() . '</option>';
                    }
                }
                $output .= '</optgroup>';
            } else {
                // no downloads found
                $output .= '<option value="">'.__( 'No result found.', 'btnsx' ).'</option>';
            }

            return $output;

            /* Restore original Post Data */
            wp_reset_postdata();
		}

		/**
		 * Woocommerce product id's as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function woocommerce_product_ids( $selected ){
			$output = '';
			$args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => -1
            );

            $the_query = new WP_Query( $args );

            // The Loop
            if ( $the_query->have_posts() ) {
            	$output .= '<optgroup label="' . __( 'Available Products' , 'btnsx' ) . '">';
            	// var_dump(get_the_id());
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();
                    if ( isset( $selected ) && $selected == get_the_id() ) {
                        $output .= '<option value="' . get_the_id() . '" selected="selected">' . get_the_title() . '</option>';
                    }else{
                        $output .= '<option value="' . get_the_id() . '">' . get_the_title() . '</option>';
                    }
                }
                $output .= '</optgroup>';
            } else {
                // no downloads found
                $output .= '<option value="">'.__( 'No result found.', 'btnsx' ).'</option>';
            }

            return $output;

            /* Restore original Post Data */
            wp_reset_postdata();
		}

		/**
		 * Function to output tooltip
		 * @since  0.1
		 * @param  array     $args
		 * @return string
		 */
		public function tooltip( $args = array() ) {

			$defaults = array(
				'class' => 'btnsx-tooltip', 
				'position' => 'right', 
				'delay' => '50', 
				'text' => 'I am tooltip'
			);

			$args = wp_parse_args( $args, $defaults );

			return '<span class="fa-stack fa-lg ' . sanitize_html_class( $args['class'] ) . '" data-position="' . esc_attr( $args['position'] ) . '" data-delay="' . esc_attr( $args['delay'] ) . '" data-tooltip="' . esc_attr( $args['text'] ) . '"><i class="far fa-question-circle"></i></span>';
		}

		/**
		 * Generate input HTML
		 * @since  0.1
		 * @param  array     $args 	existing options array
		 * @return array 	all standard DOM input options
		 */
		public function input( $args = array() ) {

			$defaults = array(
				'type'				=>	'text',
				'cpt'				=>	'post',
				'size'				=>	'12',
				'id'				=>	NULL,
				'name'				=>	NULL,
				'class'				=>	NULL,
				'multiselect'		=>	NULL,
				'title'				=>	NULL,
				'placeholder'		=>	NULL,
				'label'				=>	NULL,
				'tooltip'			=>	NULL,
				'min'				=>	0,
				'max'				=>	100,
				'on_text'			=>	__( 'On', 'btnsx' ),
				'off_text'			=>	__( 'Off', 'btnsx' ),
				'step'				=>	1,
				'value'				=>	NULL,
				'options'			=>	array(),
				'copy'				=>	NULL,
				'copy_text'			=>	NULL,
				'copy_ids'			=>	array()
			);

			// Merge arguments together 
			$input = wp_parse_args( $args, $defaults );
			$no_esc_key = array( 'cpt', 'options', 'tooltip', 'value', 'multiselect', 'copy_ids', 'copy_text', 'copy_ids' );

			// Validate the data - All input values are validated here with few exceptions, exceptions are validated on occurence
			foreach ( $input as $k => $v ) {
				if( !in_array( $k, $no_esc_key ) ) {
					$input[$k] = esc_attr( $v );
				}
			}

			// Create input attributes
			$input_props = array();
			$input_props['id'] = ( $input['id'] != NULL ) ? 'id="' . $input['id'] . '"' : NULL;
			$input_props['name'] = ( $input['name'] != NULL ) ? 'name="' . $input['name'] . '"' : NULL;
			$input_props['placeholder'] = ( $input['placeholder'] != NULL ) ? 'placeholder="' . $input['placeholder'] . '"' : NULL;
			$input_props['class'] = ( $input['class'] != NULL ) ? 'class="' . $input['class'] . '"' : NULL;
			$input_props['value'] = ( $input['value'] != NULL && !is_array( $input['value'] ) ) ? 'value="' . esc_attr( $input['value'] ) . '"' : NULL;

			// declare allowed html tags for tooltip
			$tooltip_allowed_html = array(
				'span' => array(
					'class' => array(),
					'data-position' => array(),
					'data-delay' => array(),
					'data-tooltip' => array()
				),
				'i'	=>	array(
					'class' => array()
				)
			);
			// declare allowed html tags for select options
			$select_allowed_html = array(
				'optgroup' => array(
					'label' => array()
				),
				'option' =>	array(
					'value' => array(),
					'selected' => array()
				)
			);

			switch ( $input['type'] ) {

				case 'text': ?>
					<div class="col m<?php echo $input['size']; ?>">
						<div class="input-field col s12">
							<input type="text" <?php echo implode( ' ', $input_props ); ?>>
							<?php if( $input['label'] != NULL ){ ?>
								<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
									<?php } if( $input['tooltip'] != NULL ) {
										echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
									}
									?>
								</label>
						</div>
					</div>
					<?php break;

				case 'number': ?>
					<div class="col m<?php echo $input['size']; ?>">
						<div class="input-field col s12">
							<input type="number" <?php echo implode( ' ', $input_props ); ?>>
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
						</div>
					</div>
					<?php break;

				case 'range': 

					$input_props['range_id'] = ( $input['id'] != NULL ) ? 'id="' . $input['id'] . '_range"' : NULL;
					$input_props['range_name'] = ( $input['name'] != NULL ) ? 'name="range_' . $input['name'] . '"' : NULL;
					$input_props['min'] = ( $input['min'] != NULL ) ? 'min="' . $input['min'] . '"' : 0;
					$input_props['max'] = ( $input['max'] != NULL ) ? 'max="' . $input['max'] . '"' : 100;
					$input_props['step'] = ( $input['step'] != NULL ) ? 'step="' . $input['step'] . '"' : 1;

					?>
					<div class="col m12">
						<div class="row">
							<div class="col m4 btnsx-no-padding">
								<div class="input-field col s12">
									<input type="text" <?php echo implode( ' ', $input_props ); ?>>
									<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
										<?php if( $input['tooltip'] != NULL ) {
											echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
										}
										?>
									</label>
								</div>
							</div>
							<div class="col m8 btnsx-no-padding">
								<p class="range-field">
									<input type="range" <?php echo $input_props['class'] . $input_props['range_id'] . ' ' . $input_props['range_name'] . ' ' . $input_props['min'] . ' ' . $input_props['max'] . ' ' . $input_props['step']; ?>/>
								</p>
							</div>
						</div>
					</div>
					<?php break;

				case 'select': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : 'placeholder="' . __('Choose your option','btnsx') . '"';
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="' . $input['class'] . '"' : 'class="btnsx-select"';

					$input['value'] = maybe_unserialize( $input['value'] );
					$multi_select = ( isset( $input['multiselect'] ) && $input['multiselect'] === true ) ? ' multiple="multiple"' : '';

					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<?php 
								if( $input['copy'] == true ){
									$highlight = isset( $input['copy_ids']['highlight'] ) ? $input['copy_ids']['highlight'] : '';
									$old_select = isset( $input['copy_ids']['old_select'] ) ? $input['copy_ids']['old_select'] : '';
									$new_select = isset( $input['copy_ids']['new_select'] ) ? $input['copy_ids']['new_select'] : '';
									$normal_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'normal' ? __( 'Copy to normal', 'btnsx' ) : '';
									$hover_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'hover' ? __( 'Copy to hover', 'btnsx' ) : '';
									echo '<button id="' . $input['id'] . '_copy_btn" class="btnsx-copy-field" data-highlight="' . $highlight . '" data-old-select="' . $old_select . '" data-new-select="' . $new_select . '">' . $normal_text . $hover_text . '</button>';
								}	
							?>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ) . $multi_select; ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
										<option value="-1" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php }
									// var_dump($input['options']);
									foreach ( $input['options'] as $key => $label ) {
										if( is_array( $input['value'] ) ) {
											if( in_array( $key, $input['value'] ) ) {
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '" selected>' . sanitize_text_field( $label ) . '</option>';
											} else {
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '">' . sanitize_text_field( $label ) . '</option>';
											}
										} else {
											if( $input['value'] != NULL && $input['value'] == $key ){
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '" selected>' . (string) $label . '</option>';
											} else {
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '">' . (string) $label . '</option>';
											}
										}
									}
								?>
							</select>
						</div>
					</div>
					<?php break;

				case 'icon': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : __( 'Choose your option', 'btnsx' );
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="btnsx-select ' . $input['class'] . '"' : 'class="btnsx-select"';

					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ); ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
									<option value="" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php } 
									echo wp_kses( $this->icon_options( $input['value'] ), $select_allowed_html );
								?>
							</select>
						</div>
					</div>
					<?php break;

				case 'radio': ?>
					<div class="col m<?php echo $input['size']; ?>" style="margin-bottom:20px;">
						<div class="col s12">
							<label for=""><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<?php
								unset( $input_props['id'] );
								$checkbox_value = isset( $input['value'] ) ? 'value="' . esc_attr( $input['value'] ) . '"' : '';
								foreach ( $input['options'] as $id => $value ) {
									$checkbox_checked = isset( $input['value'] ) && $input['value'] == $value ? 'checked="checked"' : '';
									echo '<p>';
									echo '<input type="radio" id="' .  esc_attr( $id ) . '" value="' .  esc_attr( $value ) . '" ' . implode( ' ', $input_props ) . $checkbox_checked .'/>';
									echo '<label for="' .  esc_attr( $id ) . '">' . ucfirst( $value ) . '</label>';
									echo '</p>';
								}
							?>
						</div>
					</div>
					<?php break;

				case 'cpt': 

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'multiselect'	=>	$input['multiselect'],
						    'options'		=>	$this->cpt( $input['cpt'], $input['value'] ),
						    'value'			=> $input['value']
						)
					);

					break;

				case 'posts': 

					$post_options = array();
					$post_options[] = $this->posts( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'multiselect'	=>	$input['multiselect'],
						    'options'		=>	$post_options
						)
					);

					break;

				case 'postlinks': 

					$post_options = array();
					$post_options[] = $this->post_links( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'multiselect'	=>	$input['multiselect'],
						    'options'		=>	$post_options
						)
					);

					break;

				case 'menu':

					$menus = get_terms('nav_menu'); $options = array();
					foreach( $menus as $menu ){
						$options[ $menu->name ] = $menu->name;
					}

					echo $this->input(
						array(
							'type'			=>	'select',
							'id'			=>	$input['id'],
							'name'			=>	$input['name'],
							'placeholder'	=>	$input['placeholder'],
							'label'			=>	$input['label'],
							'tooltip'		=>	$input['tooltip'],
							'options'		=>	$options,
							'value'			=>	$input['value']
						)
					);

					break;

				case 'checkbox': 
					$checkbox_value = isset( $input['value'] ) ? 'value="' . esc_attr( $input['value'] ) . '"' : '';
					$checkbox_checked = isset( $input['value'] ) && $input['value'] == '1' ? 'checked="checked"' : '';
					?>
					<div id="<?php echo $input['id'].'_container'; ?>" class="col m<?php echo $input['size']; ?>">
						<div class="col s12">
							<p class="btnsx-checkbox-container">
								<input type="checkbox" <?php echo implode( ' ', $input_props ) . $checkbox_value . $checkbox_checked; ?>/>
								<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
									<?php if( $input['tooltip'] != NULL ) {
										echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
									}
									?>
								</label>
							</p>
						</div>
					</div>
					<?php break;

				case 'switch': 
					$checkbox_value = isset( $input['value'] ) ? 'value="' . esc_attr( $input['value'] ) . '"' : '';
					$checkbox_checked = isset( $input['value'] ) && $input['value'] == '1' ? 'checked="checked"' : '';
					?>
					<div class="col m<?php echo $input['size']; ?>">
						<div class="col s12" style="margin-bottom:20px;">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<p>
								<!-- Switch -->
								<div class="switch">
								    <label>
								    	<?php echo $input['off_text']; ?>
										<input type="checkbox" <?php echo implode( ' ', $input_props ) . $checkbox_value . $checkbox_checked; ?>/>
										<span class="lever"></span>
										<?php echo $input['on_text']; ?>
									</label>
								</div>
							</p>
						</div>
					</div>
					<?php break;
				
				case 'trbl': 

					$trbl_fields = array(
						'all'		=>	__( 'All Sides', 'btnsx' ),
						'top'		=>	__( 'Top', 'btnsx' ),
						'bottom'	=>	__( 'Bottom', 'btnsx' ),
						'left'		=>	__( 'Left', 'btnsx' ),
						'right'		=>	__( 'Right', 'btnsx' )
					);

					foreach ( $trbl_fields as $key => $label ) { ?>
						<div class="col3">
							<?php
							echo $this->input( 
								array(
									'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['id'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : ''
								)
							);
							?>
						</div>
					<?php } break;

				case 'editor': 
					unset( $input_props['value'] );
					?>
					<div class="col m12">
							
					</div>
					<div class="col m12">
						<div class="input-field col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<textarea class="btnsx-css-editor" data-btnsx-editor="css" <?php echo implode( ' ', $input_props ); ?>><?php echo esc_textarea( $input['value'] ); ?></textarea>

						</div>
					</div>
					<?php break;

				case 'editor-js': 
					unset( $input_props['value'] );
					?>
					<div class="col m12">
							
					</div>
					<div class="col m12">
						<div class="input-field col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<textarea class="btnsx-js-editor" data-btnsx-editor="javascript" <?php echo implode( ' ', $input_props ); ?>><?php echo esc_textarea( $input['value'] ); ?></textarea>

						</div>
					</div>
					<?php break;

				case 'tinymce': ?>
					<div class="col m12">
							<?php 

								$btnsx_editor_content = '';

								wp_editor( $btnsx_editor_content, 'btnsx_opt_text', array(
								    'wpautop'       => true,
								    'media_buttons' => false,
								    'textarea_name' => 'btnsx_opt_text',
								    'textarea_rows' => 10,
								    'teeny'         => true
								) );

							?>
					</div>
					<?php break;

				case 'color': ?>
					<div class="col m12">
						<label class="btnsx-color-label" name="" for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
							<?php if( $input['tooltip'] != NULL ) {
								echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
							}
							?>
						</label>
						<?php 
							if( $input['copy'] == true ){
								$highlight = isset( $input['copy_ids']['highlight'] ) ? $input['copy_ids']['highlight'] : '';
								$old_input = isset( $input['copy_ids']['old_input'] ) ? $input['copy_ids']['old_input'] : '';
								$new_input = isset( $input['copy_ids']['new_input'] ) ? $input['copy_ids']['new_input'] : '';
								$old_color = isset( $input['copy_ids']['old_color'] ) ? $input['copy_ids']['old_color'] : '';
								$new_color = isset( $input['copy_ids']['new_color'] ) ? $input['copy_ids']['new_color'] : '';
								$normal_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'normal' ? __( 'Copy to normal', 'btnsx' ) : '';
								$hover_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'hover' ? __( 'Copy to hover', 'btnsx' ) : '';
								echo '<button id="' . $input['id'] . '_copy_btn" class="btnsx-copy-field" data-highlight="' . $highlight . '" data-old-input="' . $old_input . '" data-new-input="' . $new_input . '" data-old-color="' . $old_color . '" data-new-color="' . $new_color . '" data-old-select data-new-select>' . $normal_text . $hover_text . '</button>';
							}	
						?>
					</div>
					<?php
						echo $this->input( 
							array(
    							'type'			=>	'text',
    							'id'			=>	$input['id'],
    							'name'			=>	$input['name'],
    							'placeholder'	=>	' ',
    							'class'			=>	'btnsx-text btnsx-color',
    							'value'			=>	( isset( $input['value'] ) ? $input['value'] : NULL )
    						)
						);

					break;

				case 'font': 
					$font_fields = array(
						'size'		=>	__( 'Font Size', 'btnsx' ),
						'family'	=>	__( 'Font Family', 'btnsx' ),
						'weight'	=>	__( 'Font Weight', 'btnsx' ),
						'style'		=>	__( 'Font Style', 'btnsx' )
					);

					foreach ( $font_fields as $key => $label ) {
						if( $key == 'size' ){

							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						} elseif( $key == 'style' ) {

							echo $this->input(
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	__( 'Choose font style', 'btnsx' ),
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'options'		=>	array(
	    								'normal'		=> __( 'Normal', 'btnsx' ),
	    								'italic'		=> __( 'Italic', 'btnsx' ),
	    								'oblique'		=> __( 'Oblique', 'btnsx' ),
	    								'inherit'		=> __( 'Inherit', 'btnsx' )
	    							),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						} elseif( $key == 'weight' ) {

							echo $this->input(
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	__( 'Choose font weight', 'btnsx' ),
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'options'		=>	array(
	    								'normal'		=> __( 'Normal', 'btnsx' ),
	    								'bold'			=> __( 'Bold', 'btnsx' ),
	    								'bolder'		=> __( 'Bolder', 'btnsx' ),
	    								'lighter'		=> __( 'Lighter', 'btnsx' ),
	    								'100'			=> __( '100', 'buttons-x' ),
	    								'100italic'		=> __( '100 Italic', 'buttons-x' ),
	    								'200'			=> __( '200', 'buttons-x' ),
	    								'200italic'		=> __( '200 Italic', 'buttons-x' ),
	    								'300'			=> __( '300', 'buttons-x' ),
	    								'300italic'		=> __( '300 Italic', 'buttons-x' ),
	    								'400'			=> __( '400', 'buttons-x' ),
	    								'400italic'		=> __( '400 Italic', 'buttons-x' ),
	    								'500'			=> __( '500', 'buttons-x' ),
	    								'500italic'		=> __( '500 Italic', 'buttons-x' ),
	    								'600'			=> __( '600', 'buttons-x' ),
	    								'600italic'		=> __( '600 Italic', 'buttons-x' ),
	    								'700'			=> __( '700', 'buttons-x' ),
	    								'700italic'		=> __( '700 Italic', 'buttons-x' ),
	    								'800'			=> __( '800', 'buttons-x' ),
	    								'800italic'		=> __( '800 Italic', 'buttons-x' ),
	    								'900'			=> __( '900', 'buttons-x' ),
	    								'900italic'		=> __( '900 Italic', 'buttons-x' ),
	    								'inherit'		=> __( 'Inherit', 'btnsx' )
	    							),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						} elseif( $key == 'family' ) {

							echo $this->input(
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	__( 'Choose font family', 'btnsx' ),
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'options'		=>	$this->google_webfonts( $input['value'][$key] ),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						}
					}

					break;

				case 'color-states': 

					$color_fields = array(
						'normal' =>	__( 'Normal', 'btnsx' ),
						'hover'	=>	__( 'Hover', 'btnsx' )
					);

					$i = 0;
					foreach ( $color_fields as $key => $label ) { 
						if( !is_array($input['value']) ){
							$input['value'] = NULL;
						}
						if( !is_array($input['copy_ids']) ){
							$input['copy_ids'] = NULL;
						}
						if( !is_array($input['copy_text']) ){
							$input['copy_ids'] = NULL;
						}
						echo $this->input( 
							array(
    							'type'			=>	'color',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['name'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	$input['tooltip'][$key],
    							'class'			=>	'btnsx-color',
    							'value'			=>	$input['value'][$key],
    							'copy'			=>	$input['copy'],
    							'copy_text'		=>	$input['copy_text'][$key],
    							'copy_ids'		=>	$input['copy_ids'][$key]
    						)
						);
						$i++;
					}

					break;

				case 'gradient': 

					$gradient_fields = array(
						'location'	=>	__( 'Location', 'btnsx' ),
						'color'		=>	__( 'Color', 'btnsx' )
					);

					$i = 0;
					foreach ( $gradient_fields as $key => $label ) { 
						if( !is_array( $input['value'] ) ){
							$input['value'] = NULL;
						}
						if( $key === 'color' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'placeholder'	=>	' ',
	    							'value'			=>	$input['value'][$key]
	    						)
							);
						}
						if( $key === 'location' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'placeholder'	=>	' ',
	    							'class'			=>	'btnsx-text',
	    							'value'			=>	$input['value'][$key]
	    						)
							);
						}
						$i++;
					}

					break;

				case 'box-shadow': 

					$shadow_fields = array(
						'horizontal'	=>	__( 'Horizontal', 'btnsx' ),
						'vertical'		=>	__( 'Vertical', 'btnsx' ),
						'blur'			=>	__( 'Blur', 'btnsx' ),
						'spread'		=>	__( 'Spread', 'btnsx' ),
						'position'		=>	__( 'Position', 'btnsx' ),
						'color'			=>	__( 'Color', 'btnsx' )
					);

					foreach ( $shadow_fields as $key => $label ) { 
						if( $key == 'color' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-text btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'horizontal' || $key == 'vertical' || $key == 'blur' || $key == 'spread' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-text',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'position' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-select',
	    							'options'		=>	array(
	    								' '		=> __( 'Outset', 'btnsx' ),
	    								'inset'			=> __( 'Inset', 'btnsx' )
    								),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'text-shadow': 

					$shadow_fields = array(
						'horizontal'	=>	__( 'Horizontal', 'btnsx' ),
						'vertical'		=>	__( 'Vertical', 'btnsx' ),
						'blur'			=>	__( 'Blur', 'btnsx' ),
						'color'			=>	__( 'Color', 'btnsx' )
					);

					foreach ( $shadow_fields as $key => $label ) { 
						if( $key == 'color' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'horizontal' || $key == 'vertical' || $key == 'blur' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'radius': 

					$radius_fields = array(
						'all'			=>	__( 'All Sides', 'btnsx' ),
						'top_left'		=>	__( 'Top Left', 'btnsx' ),
						'top_right'		=>	__( 'Top Right', 'btnsx' ),
						'bottom_left'	=>	__( 'Bottom Left', 'btnsx' ),
						'bottom_right'	=>	__( 'Bottom Right', 'btnsx' )
					);

					foreach ( $radius_fields as $key => $label ) {
						echo $this->input( 
							array(
    							'type'			=>	'range',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['name'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
    						)
						);
					}

					break;

				case 'divider': 

					$divider_fields = array(
						'size'		=>	__( 'Size', 'btnsx' ),
						'position'	=>	__( 'Position', 'btnsx' ),
						'color'		=>	__( 'Color', 'btnsx' )
					);

					foreach ( $divider_fields as $key => $label ) { 
						if( $key == 'color' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'size' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'position' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'file': 

					$file_props['id'] = ( $input['id'] != NULL ) ? 'id="' . $input['id'] . '_upload"' : NULL;
					
					?>
					<div class="col m12">
						<div class="col s12">
							<label class="btnsx-upload-label" for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<?php 
								if( $input['copy'] == true ){
									$highlight = isset( $input['copy_ids']['highlight'] ) ? $input['copy_ids']['highlight'] : '';
									$old_input = isset( $input['copy_ids']['old_input'] ) ? $input['copy_ids']['old_input'] : '';
									$new_input = isset( $input['copy_ids']['new_input'] ) ? $input['copy_ids']['new_input'] : '';
									$normal_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'normal' ? __( 'Copy to normal', 'btnsx' ) : '';
									$hover_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'hover' ? __( 'Copy to hover', 'btnsx' ) : '';
									echo '<button id="' . $input['id'] . '_copy_btn" class="btnsx-copy-field" data-highlight="' . $highlight . '" data-old-input="' . $old_input . '" data-new-input="' . $new_input . '" data-old-color="" data-new-color="" data-old-select data-new-select>' . $normal_text . $hover_text . '</button>';
								}	
							?>
						</div>
					</div>
					<div class="col m12">
						<div class="col s12">
							<div class="file-field input-field">
						    	<input class="file-path btnsx-input-upload validate" type="text" <?php echo implode( ' ', $input_props ); ?>/>
						    	<div class="btn">
						    		<span><?php _e( 'UPLOAD', 'btnsx' ); ?></span>
						    		<input <?php echo $file_props['id']; ?> class="btnsx-btn-upload" type="file"/>
						    	</div>
						    </div>
						</div>
					</div>

					<?php

					break;

				case 'animation': 

					$animation_options = array();
					$animation_options[] = $this->animation_options( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'options'		=>	$animation_options
						)
					);

					break;

				case 'icon-animation': 

					$animation_options = array();
					$animation_options[] = $this->icon_animation_options( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'options'		=>	$animation_options
						)
					);

					break;

				case 'edd': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : __('Choose your option');
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="btnsx-select ' . $input['class'] . '"' : 'class="btnsx-select"';

					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html);
								}
								?>
							</label>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ); ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
									<option value="" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php } 
									echo wp_kses( $this->edd_product_ids( $input['value'] ), $select_allowed_html );
								?>
							</select>
						</div>
					</div>
					<?php break;

				case 'woocommerce': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : __('Choose your option');
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="btnsx-select ' . $input['class'] . '"' : 'class="btnsx-select"';
					// Check whether WooCommerce is active
					if( class_exists('WooCommerce') ) :
					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ); ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
									<option value="" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php } 
									echo wp_kses( $this->woocommerce_product_ids( $input['value'] ), $select_allowed_html );
								?>
							</select>
						</div>
					</div>
					<?php 
					endif;
					break;

				case 'html': ?>

					<div class="col m<?php echo $input['size']; ?>">
						<?php echo wp_kses_post( $input['value'] ); ?>
					</div>

					<?php break;

				case 'button': ?>

					<div class="col m<?php echo $input['size']; ?>">
						<div class="col m<?php echo $input['size']; ?>">
							<?php echo wp_kses_post( $input['value'] ); ?>
							<button <?php echo implode( ' ', $input_props ); ?>><?php echo $input['label']; ?></button>
						</div>
					</div>

					<?php break;

				case 'border': 

					$border_fields = array(
						'size'		=>	__( 'Size', 'btnsx' ),
						'style'		=>	__( 'Style', 'btnsx' ),
						'color'		=>	__( 'Color', 'btnsx' )
					);

					foreach ( $border_fields as $key => $label ) { 
						if( $key == 'color' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'placeholder'	=>	' ',
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'size' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'style' ) {
							echo $this->input( 
								array(
									'type'			=>	'select',
								    'id'			=>	$input['id'] . '_' . $key,
								    'name'			=>	$input['name'] . '_' . $key,
								    'placeholder'	=>	' ',
								    'label'			=>	$label,
								    'tooltip'		=>	$input['tooltip'][$key],
								    'options'		=>	array(
								    	'none'		=> __( 'None', 'btnsx' ),
								    	'hidden'	=> __( 'Hidden', 'btnsx' ),
								    	'dotted'	=> __( 'Dotted', 'btnsx' ),
								    	'dashed'	=> __( 'Dashed', 'btnsx' ),
								    	'solid'		=> __( 'Solid', 'btnsx' ),
								    	'double'	=> __( 'Double', 'btnsx' ),
								    	'groove'	=> __( 'Groove', 'btnsx' ),
								    	'ridge'		=> __( 'Ridge', 'btnsx' ),
								    	'inset'		=> __( 'Inset', 'btnsx' ),
								    	'outset'	=> __( 'Outset', 'btnsx' ),
								    	'inherit'	=> __( 'Inherit', 'btnsx' ),
								    ),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					$border_sides = array(
						'top'		=>	__( 'Top', 'btnsx' ),
						'bottom'	=>	__( 'Bottom', 'btnsx' ),
						'left'		=>	__( 'Left', 'btnsx' ),
						'right'		=>	__( 'Right', 'btnsx' )
					);

					?>
					
					<div class="row">
						<div class="col m12">
							<label style="float:left;padding-left:0.75rem;margin-top:1.2rem;"><?php _e('Sides','btnsx'); ?></label>
						</div>
					<?php 
						foreach ( $border_sides as $key => $label ) {
							echo $this->input( 
								array(
									'type'			=>	'checkbox',
									'size'			=>	3,
									'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'label'			=>	$label,
	    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
									'class'			=>	'btnsx-checkbox',
									'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : 1
								)
							);
						}
					?>

					</div>

					<?php break;

				case 'background-image': 

					$bg_image_fields = array(
						'image'		=>	__( 'Background Image', 'btnsx' ),
						// 'repeat'	=>	__( 'Background Repeat', 'btnsx' ),
						'position'	=>	__( 'Background Position', 'btnsx' )
					);

					foreach ( $bg_image_fields as $key => $label ) { 
						if( $key == 'image' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'file',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'label'			=>	$label,
	    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'repeat' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
	    							'options'		=>	array(
	    								'repeat'	=>	__( 'Repeat', 'btnsx' ),
	    								'repeat-x'	=>	__( 'Repeat X', 'btnsx' ),
	    								'repeat-y'	=>	__( 'Repeat Y', 'btnsx' ),
	    								'no-repeat'	=>	__( 'No Repeat', 'btnsx' )
	    							),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'position' ) {
							echo $this->input( 
								array(
									'type'			=>	'select',
								    'id'			=>	$input['id'] . '_' . $key,
								    'name'			=>	$input['name'] . '_' . $key,
								    'placeholder'	=>	' ',
								    'label'			=>	$label,
								    'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
								    'options'		=>	array(
								    	'left top'		=> __( 'Left Top', 'btnsx' ),
								    	'left center'	=> __( 'Left Center', 'btnsx' ),
								    	'left bottom'	=> __( 'Left Bottom', 'btnsx' ),
								    	'right top'		=> __( 'Right Top', 'btnsx' ),
								    	'right center'	=> __( 'Right Center', 'btnsx' ),
								    	'right bottom'	=> __( 'Right Bottom', 'btnsx' ),
								    	'center top'	=> __( 'Center Top', 'btnsx' ),
								    	'center center'	=> __( 'Center Center', 'btnsx' ),
								    	'center bottom'	=> __( 'Center Bottom', 'btnsx' ),
								    	'initial'		=> __( 'Initial', 'btnsx' ),
								    ),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'width-height':

					$wh_fields = array(
						'width'		=>	__( 'Width', 'btnsx' ),
						'height'	=>	__( 'Height', 'btnsx' )
					);

					echo '<div class="row">';

					foreach ( $wh_fields as $key => $label ) { 
						echo '<div class="col s6">';
						echo $this->input( 
							array(
    							'type'			=>	'range',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['name'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
    						)
						);
						echo '</div>';
					}

					echo '</div>';

					break;

				case 'padding':

					$padding_fields = array(
						'all'		=>	__( 'Padding All Sides', 'btnsx' ),
						'top'		=>	__( 'Padding Top', 'btnsx' ),
						'bottom'	=>	__( 'Padding Bottom', 'btnsx' ),
						'left'		=>	__( 'Padding Left', 'btnsx' ),
						'right'		=>	__( 'Padding Right', 'btnsx' )
					);

					foreach ( $padding_fields as $key => $label ) {
						echo $this->input( 
							array(
								'type'			=>	'range',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['id'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	$input['tooltip'][$key],
    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : ''
							)
						);
					}

					break;

				default: ?>
					<input type="hidden" <?php echo implode( ' ', $input_props ); ?>>
					<?php break;
			
			}
		}

	} // Form Elements Class

}